﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Site
{
    public partial class SiteEdit : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Set_Control();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            int IsDefault = chx_Default.Checked ? 1 : 0;
            if (IsDefault == 1)
            {
                KstCmsBase.DAL.Access db = new KstCmsBase.DAL.Access();
                db.ExecuteSql("update WebSite set DefaultSite=0");
                db.Dispose();
            }
            int IsAct = chx_Act.Checked ? 1 : 0;
            string[] data = new string[]{
                txt_VerName.Text.Trim(),
                txt_SiteName.Text.Trim(),
                txt_SiteTitle.Text.Trim(),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                Request.Form.Get("txt_CopyRight"),
                IsDefault.ToString(),
                txt_SortNo.Text.Trim(),
                IsAct.ToString(),
                drp_TempList.SelectedValue
            };
            KstCmsBase.DAL.WebSite.Update(data, Convert.ToInt32(Request.QueryString.Get("SiteId")), "VerName", "SiteName", "SiteTitle", "MateKey", "MateDesc", "CopyRight", "DefaultSite", "SortNO", "SiteACT", "TempID");
            ShowMsgModle("设置成功！");
            KstCmsBase.Common.Fucs.CreateDir(Server.MapPath("~/" + lit_SiteVer.Text.Trim().ToLower()));
        }

        void Set_Control()
        {
            string[] Cons = new string[] { "版本别名~!", "网站名称~!", "网站标题~!", "Meta关键字~!", "Meta注解~!", "排序~int!" };
            base.Set_Control(Cons, txt_VerName, txt_SiteName, txt_SiteTitle, txt_MateKey, txt_MateDesc, txt_SortNo);
            GetSite(Request.QueryString.Get("SiteId"));
            
            
        }
        void GetSite(string SiteId)
        {
            KstCmsBase.Entities.WebSite_ent Site = KstCmsBase.DAL.WebSite.Get_WebSite_Info(Convert.ToInt32(SiteId));
            lit_SiteVer.Text = Site.SiteVer;
            txt_VerName.Text = Site.VerName;
            txt_SiteName.Text = Site.SiteName;
            txt_SiteTitle.Text = Site.SiteTitle;
            txt_MateKey.Text = Site.MateKey;
            txt_MateDesc.Text = Site.MateDesc;
            txt_CopyRight.Value = Site.CopyRight;
            chx_Default.Checked = Site.DefaultSite == 1;
            chx_Act.Checked = Site.SiteACT == 1;
            txt_SortNo.Text = Site.SortNO.ToString();
            ShowDrpTempList();
            drp_TempList.SelectedValue = Site.TempID.ToString();
        }

        void ShowDrpTempList()
        {
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.HomePage);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                if (Temp.DefaultAct == 1)
                    item.Selected = true;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));
        }

    }
}