﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Site
{
    public partial class SiteList : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            repMain.ItemCommand += new RepeaterCommandEventHandler(repMain_ItemCommand);
            repMain.ItemDataBound += new RepeaterItemEventHandler(repMain_ItemDataBound);
            if (!IsPostBack)
            {
                repMain_bind();
            }
        }

        void repMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                int IsDefaultSite = ((KstCmsBase.Entities.WebSite_ent)e.Item.DataItem).DefaultSite;
                if (IsDefaultSite == 1)
                    ((Literal)e.Item.FindControl("lit_Url")).Text = "<a href=\"" + SysRootUrl + "/\" target=\"_blank\">打开</a>";
                else
                    ((Literal)e.Item.FindControl("lit_Url")).Text = "<a href=\"" + SysRootUrl + "/" + ((KstCmsBase.Entities.WebSite_ent)e.Item.DataItem).SiteVer + "/\" target=\"_blank\">打开</a>";

            }
        }

        void repMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            KstCmsBase.DAL.Access db = new KstCmsBase.DAL.Access();
            string SiteVer = db.getFieldValue(string.Format("select SiteVer from WebSite where SiteID={0}", e.CommandName.ToString()));
            db.Dispose();
            KstCmsBase.DAL.WebSite.Delete(e.CommandName.ToString());
            KstCmsBase.Common.Fucs.DeleteDir(Server.MapPath("~/" + SiteVer));
            repMain_bind();
        }



        void repMain_bind()
        {
            repMain.DataSource = KstCmsBase.DAL.WebSite.Get_WebSiteList();
            repMain.DataBind();
        }

    }
}