﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.mytag
{
    public partial class VarTAGLIST :KstCmsBase.WebPage.ValidationPage
    {
        string lbid = System.Web.HttpContext.Current.Request.QueryString.Get("lbid");
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_Lblist.SelectedIndexChanged += new EventHandler(drp_Lblist_SelectedIndexChanged);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            if (!IsPostBack)
            {
                ShowdrpVarlblist();
                if (!string.IsNullOrEmpty(lbid))
                    drp_Lblist.SelectedValue = lbid;
                RepMain_Bind();
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            KstCmsBase.DAL.Tag.TagTEMP.VarTAG_Delete(Convert.ToInt32(e.CommandName.ToString()));
            RepMain_Bind();
        }

        void drp_Lblist_SelectedIndexChanged(object sender, EventArgs e)
        {
            RepMain_Bind();
        }

        void RepMain_Bind()
        {
            if (!string.IsNullOrEmpty(drp_Lblist.SelectedValue))
            {
                System.Collections.ArrayList items = null;
                KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection(Convert.ToInt32(drp_Lblist.SelectedValue));
                AspNetPager1.RecordCount = VarTAG_Items.Count;
                if (AspNetPager1.RecordCount == 0)
                    AspNetPager1.CurrentPageIndex = 0;
                if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
                {
                    items = VarTAG_Items.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
                }
                else
                {
                    int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                    items = VarTAG_Items.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
                }
                RepMain.DataSource = items;
                RepMain.DataBind();
            }
        }

        void ShowdrpVarlblist()
        {
            KstCmsBase.Collection.Tag.VarLBTAGCollection VarLBTAG_ITEMS = KstCmsBase.DAL.Tag.TagTEMP.GetVarLBTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarLBTAG lbitem in VarLBTAG_ITEMS)
            {
                ListItem item = new ListItem();
                item.Value = lbitem.VarLBID.ToString();
                item.Text = lbitem.VarNAME;
                drp_Lblist.Items.Add(item);
            }
        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_Bind();

        }
    }
}