﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.systag
{
    public partial class SystagList : KstCmsBase.WebPage.ValidationPage
    {
        string lbid = System.Web.HttpContext.Current.Request.QueryString.Get("lbid");
        protected void Page_Load(object sender, EventArgs e)
        {
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            drp_Lblist.SelectedIndexChanged += new EventHandler(drp_Lblist_SelectedIndexChanged);
            if (!IsPostBack)
            {
                ShowDrpLB();
                if (!string.IsNullOrEmpty(lbid))
                    drp_Lblist.SelectedValue = lbid;
                RepMain_Bind();
            }
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                //int isAdmin = KstCmsBase.DAL.Users.Get_UserInfo(User.Identity.Name).isAdmin;
                ((Button)e.Item.FindControl("Button1")).Enabled = isAdmin;
            }
        }

        void drp_Lblist_SelectedIndexChanged(object sender, EventArgs e)
        {
            RepMain_Bind();
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int TagID = Convert.ToInt32(e.CommandName.ToString());
            KstCmsBase.DAL.Tag.SysTAG.SysTAG_Delete(TagID);
            RepMain_Bind();
        }

        void RepMain_Bind()
        {
            if (!string.IsNullOrEmpty(drp_Lblist.SelectedValue))
            {
                KstCmsBase.Collection.Tag.SysTAGCollection SysTAG_Items = KstCmsBase.DAL.Tag.SysTAG.GetSysTagItems(Convert.ToInt32(drp_Lblist.SelectedValue));
                System.Collections.ArrayList items = null;
                AspNetPager1.RecordCount = SysTAG_Items.Count;
                if (AspNetPager1.RecordCount == 0)
                    AspNetPager1.CurrentPageIndex = 0;
                if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
                {
                    items = SysTAG_Items.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
                }
                else
                {
                    int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex-1) * AspNetPager1.PageSize);
                    items = SysTAG_Items.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
                }
                RepMain.DataSource = items;
                RepMain.DataBind();
            }
        }

        void ShowDrpLB()
        {
            KstCmsBase.Collection.Tag.SysTAGLBCollection SysTAGLBS = KstCmsBase.DAL.Tag.SysTAG.GetSysTAGLB_Items();
            foreach (KstCmsBase.Entities.Tag.SysTAGLB_ent SysTAGLB in SysTAGLBS)
            {
                ListItem item = new ListItem();
                item.Value = SysTAGLB.SysLBID.ToString();
                item.Text = SysTAGLB.LbNAME;
                drp_Lblist.Items.Add(item);
            }
        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_Bind();

        }


    }
}