﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.tagdoc
{
    public partial class DescList :KstCmsBase.WebPage.ValidationPage
    {
        string lbid = System.Web.HttpContext.Current.Request.QueryString.Get("lbid");
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_Lblist.SelectedIndexChanged += new EventHandler(drp_Lblist_SelectedIndexChanged);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            if (!IsPostBack)
            {
                ShowDrpLB();
                if (!string.IsNullOrEmpty(lbid))
                    drp_Lblist.SelectedValue = lbid;
                RepMain_Bind();
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int TagID = Convert.ToInt32(e.CommandName.ToString());
            KstCmsBase.DAL.Tag.TagTEMP.TagDESC_Delete(TagID);
            RepMain_Bind();
        }

        void drp_Lblist_SelectedIndexChanged(object sender, EventArgs e)
        {
            RepMain_Bind();
        }

        void RepMain_Bind()
        {
            if (!string.IsNullOrEmpty(drp_Lblist.SelectedValue))
            {
                KstCmsBase.Collection.Tag.TagDescCollection Items = KstCmsBase.DAL.Tag.TagTEMP.Get_TagDescItems(Convert.ToInt32(drp_Lblist.SelectedValue));
                System.Collections.ArrayList items = null;
                AspNetPager1.RecordCount = Items.Count;
                if (AspNetPager1.RecordCount == 0)
                    AspNetPager1.CurrentPageIndex = 0;
                if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
                {
                    items = Items.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
                }
                else
                {
                    int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                    items = Items.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
                }
                RepMain.DataSource = items;
                RepMain.DataBind();
            }
        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_Bind();

        }

        void ShowDrpLB()
        {
            KstCmsBase.Collection.Tag.TagDescLBCollection LbItems = KstCmsBase.DAL.Tag.TagTEMP.Get_TagDescLBItems();
            foreach (KstCmsBase.Entities.Tag.TagDESCLB_ent lb in LbItems)
            {
                ListItem item = new ListItem();
                item.Value = lb.LBID.ToString();
                item.Text = lb.LBNAME;
                drp_Lblist.Items.Add(item);
            }
        }
    }
}