﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.tagtmp
{
    public partial class TagTEMP_edit : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                GetTagTemp();
                SetControl();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string TagID = Request.QueryString.Get("TagID");
            string[] data = new string[]{
                drp_TempLB.SelectedValue,
                txt_TagName.Text.Trim(),
                txt_TagContent.Value,
                txt_TagList.Value,
                txt_TitleLen.Text.Trim(),
                txt_DocLEN.Text.Trim(),
                UtimeFormat.SelectedValue
           };
            KstCmsBase.DAL.Tag.TagTEMP.TagTemp_Update(Convert.ToInt32(TagID), data, "TagLbID", "TagName", "ContentTAG", "ListTAG", "TitleLEN", "DocLEN","UtimeFormat");
            ShowMsgModle("修改成功！", "location.href='TagTempList.aspx?lbid" + drp_TempLB.SelectedValue + "';");
        }

        void GetTagTemp()
        {
            string TagID = Request.QueryString.Get("TagID");
            KstCmsBase.Entities.Tag.TagTEMP_ent TagTEMP = KstCmsBase.DAL.Tag.TagTEMP.Get_TagTEMP(Convert.ToInt32(TagID));
            ShowdrpList();
            drp_TempLB.SelectedValue = TagTEMP.TagLbID.ToString();
            txt_TagName.Text = TagTEMP.TagName;
            txt_DocLEN.Text = TagTEMP.DocLEN.ToString();
            txt_TitleLen.Text = TagTEMP.TitleLEN.ToString();
            txt_TagContent.Value = TagTEMP.ContentTAG;
            txt_TagList.Value = TagTEMP.ListTAG;
            UtimeFormat.SelectedValue = TagTEMP.UtimeFormat.ToString();
        }

        void ShowdrpList()
        {
            KstCmsBase.Collection.Tag.TagTempLBCollection TagTempLBItems = KstCmsBase.DAL.Tag.TagTEMP.TagTempLBItems();
            foreach (KstCmsBase.Entities.Tag.TagTEMPLB_ent TagLB in TagTempLBItems)
            {
                ListItem item = new ListItem();
                item.Value = TagLB.TagLBID.ToString();
                item.Text = TagLB.TagLBNAME;
                drp_TempLB.Items.Add(item);
            }
            drp_TempLB.Items.Insert(0, new ListItem("请选择所属分类", "0"));
        }
        void SetControl()
        {
            string[] Cons = new string[]{
                "所属分类~!",
                "标签名称~!",
                "标题长度~int!",
                "简介长度~int!",
            };
            base.Set_Control(Cons, drp_TempLB, txt_TagName, txt_TitleLen, txt_DocLEN);
        }
    }
}