﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.WebMenu
{
    public partial class MenuEdit : KstCmsBase.WebPage.FrmControl
    {
        string MenuId = System.Web.HttpContext.Current.Request.QueryString.Get("MenuId");
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            RadioButtonList1.SelectedIndexChanged += new EventHandler(RadioButtonList1_SelectedIndexChanged);
            if (!IsPostBack)
            {
                Get_WebMenuInfo();
            }
        }

        void RadioButtonList1_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowNextLM(drp_SiteList.SelectedValue, Convert.ToInt32(RadioButtonList1.SelectedValue));
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string FileDir = txt_MenuDiy.Text.Trim();
            string SiteDir = ((KstCmsBase.Entities.WebSite_ent)KstCmsBase.DAL.WebSite.Get_WebSite_Info(Convert.ToInt32(drp_SiteList.SelectedValue), "SiteVer")).SiteVer;
            if (chx_IsOutUrl.Checked)
            {
                if (txt_GoUrl.Text[0].ToString() != "/" && txt_GoUrl.Text.ToLower().IndexOf("http://") == -1)
                {
                    throw new ExecutionEngineException("如果是外部链接，此处应该是绝对路径\"/\"或\"http://\"开头的。");
                }
                FileDir = "";
            }
            string IsOutUrl = chx_IsOutUrl.Checked ? "1" : "0";
            string Act = chx_Act.Checked ? "1" : "0";
            string IsShow = chx_IsShow.Checked ? "1" : "0";
            string[] data = new string[]{
                drp_SiteList.SelectedValue,
                txt_MenuName.Text.Trim(),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                FileDir,
                txt_GoUrl.Text.Trim(),
                IsOutUrl,
                drp_GoLmID.SelectedValue,
                RadioButtonList1.SelectedValue,
                Act,
                txt_SortNo.Text.Trim(),
                drp_TempList.SelectedValue,
                IsShow
            };
            KstCmsBase.DAL.WebMenu.Update(data, Convert.ToInt32(MenuId), "SiteID", "MenuName", "MateKey", "MateDesc", "MenuDiy", "GoUrl", "IsOutUrl", "GoLmID", "AttRib", "Act", "SortNo", "TempID", "IsShow");
            if (FileDir != "" && !string.IsNullOrEmpty(FileDir))
            {
                //创建目录
                KstCmsBase.Common.Fucs.CreateDir(Server.MapPath("~/" + SiteDir + "/" + FileDir));
            }
            ShowMsgModle("设置成功！", "onClickOutLink();");
        }

        void Get_WebMenuInfo()
        {
            ShowSiteDrp();
            KstCmsBase.Entities.WebMenu_ent WebMenu = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(Convert.ToInt32(MenuId));
            drp_SiteList.SelectedValue = WebMenu.SiteID.ToString();
            txt_MenuName.Text = WebMenu.MenuName;
            txt_MateKey.Text = WebMenu.MateKey;
            txt_MateDesc.Text = WebMenu.MateDesc;
            txt_MenuDiy.Text = WebMenu.MenuDiy;
            if (txt_MenuDiy.Text.Trim() != "")
            {
                txt_MenuDiy.Enabled = false;
                txt_MenuDiy.BackColor = System.Drawing.Color.SeaShell;
            }
            txt_GoUrl.Text = WebMenu.GoUrl;
            if (txt_GoUrl.Text.Substring(0,1) != "/" && txt_GoUrl.Text.ToLower().IndexOf("http://") == -1)
            {
                txt_GoUrl.Enabled = false;
                txt_GoUrl.BackColor = System.Drawing.Color.SeaShell;
            }
            chx_IsOutUrl.Checked = WebMenu.IsOutUrl == 1;
            
            chx_IsOutUrl.Enabled = false;

            RadioButtonList1.SelectedValue = WebMenu.AttRib.ToString();
            //RadioButtonList1.Enabled = false;
            chx_Act.Checked = WebMenu.Act == 1;
            chx_IsShow.Checked = WebMenu.IsShow == 1;
            txt_SortNo.Text = WebMenu.SortNo.ToString();
            ShowNextLM(drp_SiteList.SelectedValue, WebMenu.AttRib);
            drp_GoLmID.SelectedValue = WebMenu.GoLmID.ToString();
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
            drp_TempList.SelectedValue = WebMenu.TempID.ToString();
        }



        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
        }

        void ShowNextLM(string SiteID,int Attrib)
        {
            drp_GoLmID.Items.Clear();
            switch (Attrib)
            {
                case 0:
                    KstCmsBase.Collection.WebLmCollection WebLM = KstCmsBase.DAL.WebLM.Get_LMList(Convert.ToInt32(SiteID), Convert.ToInt32(MenuId), 1, "LmID", "LmName");
                    for (int i = 0; i < WebLM.Count; i++)
                    {
                        ListItem item = new ListItem();
                        item.Value = ((KstCmsBase.Entities.WebLm_ent)WebLM[i]).LmID.ToString();
                        item.Text = ((KstCmsBase.Entities.WebLm_ent)WebLM[i]).LmName.ToString();
                        drp_GoLmID.Items.Add(item);
                    }
                    break;
                case 1:
                    KstCmsBase.Common.HtmlControl.ProLB_HtmlControls drp = new KstCmsBase.Common.HtmlControl.ProLB_HtmlControls(SiteID, MenuId);
                    drp.Showdrp_LBID(0, ref this.drp_GoLmID);
                    break;
                case 2:
                    KstCmsBase.Collection.Wz.WzLBCollection Wzlbitems = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(Convert.ToInt32(SiteID), Convert.ToInt32(MenuId), "LbID", "LbName");
                    foreach (KstCmsBase.Entities.Wz.WzLB_Ent wzlb in Wzlbitems)
                    {
                        ListItem item = new ListItem();
                        item.Value = wzlb.LbID.ToString();
                        item.Text = wzlb.LbName.ToString();
                        drp_GoLmID.Items.Add(item);
                    }
                    break;
                case 3:
                    break;
                case 4:
                    break;

            }
            drp_GoLmID.Items.Insert(0, new ListItem("不邦定子栏目网页", "0"));
        }

        void ShowDrpTempList(int SiteId)
        {
            drp_TempList.Items.Clear();
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.LmPage, SiteId);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                if (Temp.DefaultAct == 1)
                    item.Selected = true;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));

        }

    }
}