﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.upage
{
    public partial class uPageList :KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteId.SelectedIndexChanged += new EventHandler(drp_SiteId_SelectedIndexChanged);
            drp_MenuId.SelectedIndexChanged += new EventHandler(drp_MenuId_SelectedIndexChanged);
            repMain.ItemCommand += new RepeaterCommandEventHandler(repMain_ItemCommand);
            if (!IsPostBack)
            {
                Set_Control();
            }
        }

        void repMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            string HtmlExt = KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
            KstCmsBase.Entities.WebLm_ent WebLM = KstCmsBase.DAL.WebLM.Get_WebLMInfo(Convert.ToInt32(e.CommandName.ToString()), "uPageFile");
            KstCmsBase.DAL.Access db = new KstCmsBase.DAL.Access();
            string SiteVer = db.getFieldValue(string.Format("select SiteVer from WebSite where SiteID={0}", drp_SiteId.SelectedValue));
            string MenuDir = db.getFieldValue(string.Format("select MenuDiy from WebMenu where MenuID={0}", drp_MenuId.SelectedValue));
            string WebFile = SysRootUrl + "/" + SiteVer + "/" + MenuDir + "/" + WebLM.uPageFile + HtmlExt;
            db.Dispose();
            KstCmsBase.Common.Fucs.DeleteFile(Server.MapPath(WebFile));
            KstCmsBase.DAL.WebLM.Delete(e.CommandName.ToString());
            repMain_bind();

        }

        void drp_MenuId_SelectedIndexChanged(object sender, EventArgs e)
        {
            repMain_bind();
        }

        void drp_SiteId_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenu(drp_SiteId.SelectedValue);

        }

        void repMain_bind()
        {
            if (Convert.ToInt32(drp_SiteId.SelectedValue) != 0 && Convert.ToInt32(drp_MenuId.SelectedValue) != 0)
            {
                repMain.DataSource = KstCmsBase.DAL.WebLM.Get_LMList(Convert.ToInt32(drp_SiteId.SelectedValue), Convert.ToInt32(drp_MenuId.SelectedValue), "LmID", "LmName");
                repMain.DataBind();
            }
        }

        void Set_Control()
        {
            ShowSiteDrp();
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteId.Items.Add(item);
            }
            drp_SiteId.Items.Insert(0, new ListItem("请选择站点", "0"));
        }

        void ShowMenu(string SiteID)
        {
            drp_MenuId.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenu = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteID),1,0,"MenuID","MenuName");
            for (int i = 0; i < WebMenu.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenu[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenu[i]).MenuName.ToString();
                drp_MenuId.Items.Add(item);
            }
            drp_MenuId.Items.Insert(0, new ListItem("请选择导航", "0"));

        }

    }
}