﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCmsBase.Collection.Product
{
    public class ProductCollection:BaseCollection
    {
        public enum SortFields { LbID, ProNo, ProName, uTime, SortNo }

        public void Sort(SortFields SortField, bool isAscending)
        {
            switch (SortField)
            {
                case SortFields.LbID:
                    base.Sort(new LbID_Comparer());
                    break;
                case SortFields.ProNo:
                    base.Sort(new ProNo_Comparer());
                    break;
                case SortFields.ProName:
                    base.Sort(new ProName_Comparer());
                    break;
                case SortFields.uTime:
                    base.Sort(new uTime_Comparer());
                    break;
                case SortFields.SortNo:
                    base.Sort(new SortNo_Comparer());
                    break;
            }
            if (!isAscending) base.Reverse();
        }

        private sealed class LbID_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Product.Product_Ent first = (KstCmsBase.Entities.Product.Product_Ent)x;
                KstCmsBase.Entities.Product.Product_Ent second = (KstCmsBase.Entities.Product.Product_Ent)y;
                return first.LbID.CompareTo(second.LbID);
            }
        }

        private sealed class ProNo_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Product.Product_Ent first = (KstCmsBase.Entities.Product.Product_Ent)x;
                KstCmsBase.Entities.Product.Product_Ent second = (KstCmsBase.Entities.Product.Product_Ent)y;
                return first.ProNo.CompareTo(second.ProNo);
            }
        }

        private sealed class ProName_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Product.Product_Ent first = (KstCmsBase.Entities.Product.Product_Ent)x;
                KstCmsBase.Entities.Product.Product_Ent second = (KstCmsBase.Entities.Product.Product_Ent)y;
                return first.ProName.CompareTo(second.ProName);
            }
        }

        private sealed class uTime_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Product.Product_Ent first = (KstCmsBase.Entities.Product.Product_Ent)x;
                KstCmsBase.Entities.Product.Product_Ent second = (KstCmsBase.Entities.Product.Product_Ent)y;
                return first.uTime.CompareTo(second.uTime);
            }
        }

        private sealed class SortNo_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Product.Product_Ent first = (KstCmsBase.Entities.Product.Product_Ent)x;
                KstCmsBase.Entities.Product.Product_Ent second = (KstCmsBase.Entities.Product.Product_Ent)y;
                return first.SortNo.CompareTo(second.SortNo);
            }
        }





    }

    public class ProductFileCollection : BaseCollection
    {
    }
    public class ProductPicCollection : BaseCollection
    {
    }

}
