﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCmsBase.DAL
{
    public class EmlServer
    {
        public static KstCmsBase.Entities.EmlServer Get_EmlServer()
        {
            string sql = "select * from EmlServer";
            KstCmsBase.Entities.EmlServer Eml = new Entities.EmlServer();
            Access db = new Access();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                Eml.id = Convert.ToInt32(dr["ID"].ToString());
                Eml.Email = dr["Email"].ToString();
                Eml.Smtp = dr["Smtp"].ToString();
                Eml.Pwd = dr["Pwd"].ToString();
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Eml;
        }

        public static int Eml_update(string[] Values)
        {
            Access db = new Access();
            int r=db.DataUpdate("EmlServer", "ID", 1, Values, "Email", "Smtp", "Pwd");
            db.Dispose();
            return r;
        }

        /// <summary>
        /// 发送邮件
        /// </summary>
        /// <param name="Subject">发送的邮件标题</param>
        /// <param name="Body">邮件内容</param>
        /// <param name="EnCode">编码</param>
        /// <param name="Mails">发送的邮件地址列表</param>
        /// <returns>返回1发送成功，返回0发送失败</returns>
        public static int Mailto(string Subject,string Body,System.Text.Encoding EnCode,params string[] Mails)
        {
            int Mailtoed = 1;
            KstCmsBase.Entities.EmlServer Eml = Get_EmlServer();
            System.Net.Mail.MailMessage EmailMsg = new System.Net.Mail.MailMessage();
            foreach (string toMail in Mails)
            {
                EmailMsg.To.Add(toMail);
            }
            EmailMsg.From = new System.Net.Mail.MailAddress(Eml.Email, Subject, EnCode);
            EmailMsg.Subject = Subject;
            EmailMsg.SubjectEncoding = EnCode;
            EmailMsg.Body = Body;
            EmailMsg.BodyEncoding = EnCode;
            EmailMsg.IsBodyHtml = true;
            EmailMsg.Priority = System.Net.Mail.MailPriority.High;
            System.Net.Mail.SmtpClient Client = new System.Net.Mail.SmtpClient();
            Client.Credentials = new System.Net.NetworkCredential(Eml.Email, Eml.Pwd);
            Client.Host = Eml.Smtp;
            object UserState = EmailMsg;
            try
            {
                Client.Send(EmailMsg);

            }
            catch
            {
                Mailtoed = 0;
            }
            finally
            {
                EmailMsg.Dispose();

            }
            return Mailtoed;
        }


    }
}
