﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.OleDb;
using KstCmsBase.Collection.Link;
using KstCmsBase.Entities.Link;
using KstCmsBase.DAL;

namespace KstCmsBase.DAL.Link
{
    public class FLink
    {
        public enum LinkType { allLink, ActLink, NoActLink };
        public enum Ltype { logoLink, wzLink };
        #region-----------链接类别方法----------------------
        public static LinkLBCollection Get_LinkLB_Items()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from LinkLB order by SortNo asc");
            LinkLBCollection items = new LinkLBCollection();
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                LinkLB item = new LinkLB();
                item.LbID = Convert.ToInt32(dr["LbID"].ToString());
                item.LbName = dr["LbName"].ToString();
                item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }
        public static LinkLB Get_LinkLbInfo(int Id)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from LinkLB where LbID=" + Id);
            LinkLB item = new LinkLB();
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.LbID = Convert.ToInt32(dr["LbID"].ToString());
                item.LbName = dr["LbName"].ToString();
                item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static int LinkLB_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "LinkLB", Fields);
            db.Dispose();
            return r;
        }

        public static int LinkLB_Update(int id, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("LinkLB", "LbID", id, data, Fields);
            db.Dispose();
            return r;
        }

        public static int LinkLB_delete(int id)
        {
            Access db = new Access();
            if (Convert.ToInt32(db.getFieldValue("select count(LinkID) as id from Flink where LbID=" + id)) > 0)
            {
                db.Dispose();
                throw new Exception("此类别存在相关链接，不能直接删除！");
            }
            int r = db.DataDelete("LinkLB", "LbID", id);
            db.Dispose();
            return r;
        }
        #endregion

        #region-------------链接相关方法-------------------
        public static LinkCollection Get_Link_Items(int SiteId,int MenuId,LinkType Type)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder(string.Format("from Flink where SiteID={0}", SiteId.ToString()));
            if (MenuId>0)
                sqlsb.Append(string.Format(" and MenuID={0}",MenuId.ToString()));
            switch (Type)
            {
                case LinkType.allLink:
                    break;
                case LinkType.ActLink:
                    sqlsb.Append(" and Act=1");
                    break;
                case LinkType.NoActLink:
                    sqlsb.Append(" and Act=0");
                    break;
            }
            sqlsb.Append(" order by SortNo asc");
            string sql = db.Get_DbSQL(sqlsb.ToString());
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            LinkCollection items = new LinkCollection();
            while (dr.Read())
            {
                LinkEnt item = new LinkEnt();
                item.LinkID = Convert.ToInt32(dr["LinkID"].ToString());
                item.LbID = Convert.ToInt32(dr["LbID"].ToString());
                item.SiteID = Convert.ToInt32(dr["SiteID"].ToString());
                item.MenuID = Convert.ToInt32(dr["MenuID"].ToString());
                item.SiteName = dr["SiteName"].ToString();
                item.LinkName = dr["LinkName"].ToString();
                item.LinkUrl = dr["LinkUrl"].ToString();
                item.LogoUrl = dr["LogoUrl"].ToString();
                item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                item.Act = Convert.ToInt32(dr["Act"].ToString());
                item.isHome = Convert.ToInt32(dr["isHome"].ToString());
                item.LbName = Get_LinkLbInfo(item.LbID).LbName;
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }

        public static LinkCollection Get_Link_Items(int SiteId, int MenuId, Ltype LType,int TopNum)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder(string.Format("from Flink where SiteID={0}", SiteId.ToString()));
            if (MenuId > 0)
                sqlsb.Append(string.Format(" and MenuID={0}", MenuId.ToString()));
            switch (LType)
            {
                case Ltype.logoLink:
                    sqlsb.Append(" and LogoUrl<>''");
                    break;
                case Ltype.wzLink:
                    sqlsb.Append(" and LogoUrl=''");
                    break;
            }
            sqlsb.Append(" order by SortNo asc");
            string sql = db.Get_DbSQL(sqlsb.ToString(), TopNum);
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            LinkCollection items = new LinkCollection();
            while (dr.Read())
            {
                LinkEnt item = new LinkEnt();
                item.LinkID = Convert.ToInt32(dr["LinkID"].ToString());
                item.LbID = Convert.ToInt32(dr["LbID"].ToString());
                item.SiteID = Convert.ToInt32(dr["SiteID"].ToString());
                item.MenuID = Convert.ToInt32(dr["MenuID"].ToString());
                item.SiteName = dr["SiteName"].ToString();
                item.LinkName = dr["LinkName"].ToString();
                item.LinkUrl = dr["LinkUrl"].ToString();
                item.LogoUrl = dr["LogoUrl"].ToString();
                item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                item.Act = Convert.ToInt32(dr["Act"].ToString());
                item.isHome = Convert.ToInt32(dr["isHome"].ToString());
                item.LbName = Get_LinkLbInfo(item.LbID).LbName;
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }

        public static LinkEnt Get_LinkInfo(int FLinkId)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from Flink where LinkID={0}", FLinkId.ToString()));
            LinkEnt item = new LinkEnt();
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.LinkID = Convert.ToInt32(dr["LinkID"].ToString());
                item.LbID = Convert.ToInt32(dr["LbID"].ToString());
                item.SiteID = Convert.ToInt32(dr["SiteID"].ToString());
                item.MenuID = Convert.ToInt32(dr["MenuID"].ToString());
                item.SiteName = dr["SiteName"].ToString();
                item.LinkName = dr["LinkName"].ToString();
                item.LinkUrl = dr["LinkUrl"].ToString();
                item.LogoUrl = dr["LogoUrl"].ToString();
                item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                item.isHome = Convert.ToInt32(dr["isHome"].ToString());
                item.Act = Convert.ToInt32(dr["Act"].ToString());
                item.LbName = Get_LinkLbInfo(item.LbID).LbName;
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static int Link_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "Flink", Fields);
            db.Dispose();
            return r;
        }

        public static int Link_Update(int LinkId, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("FLink", "LinkID", LinkId, data, Fields);
            db.Dispose();
            return r;
        }

        public static int Link_delete(int LinkId)
        {
            string Logo = Get_LinkInfo(LinkId).LogoUrl;
            if (!string.IsNullOrEmpty(Logo) && Logo != "")
            {
                Logo = Logo.ToLower();
                if (Logo.IndexOf("http://") == -1)
                    KstCmsBase.Common.Fucs.DeleteFile(System.Web.HttpContext.Current.Server.MapPath(Logo));
            }
            Access db = new Access();
            int r=db.DataDelete("FLink", "LinkID", LinkId);
            db.Dispose();
            return r;
        }

        #endregion



    }
}
