﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection.Product;
using KstCmsBase.Entities.Product;

namespace KstCmsBase.DAL.Product
{
    public class ProLB
    {
        public static void GetField(DataRow row, string FieldName, ref ProLB_Ent ProLb)
        {
               string FieldValue = row[FieldName].ToString();
               switch (FieldName)
               {
                   case "LbID":
                       ProLb.LbID = Convert.ToInt32(FieldValue);
                       break;
                   case "ParentID":
                       ProLb.ParentID = Convert.ToInt32(FieldValue);
                       break;
                   case "LbName":
                       ProLb.LbName = FieldValue;
                       break;
                   case "LbIMG":
                       ProLb.LbIMG = FieldValue;
                       break;
                   case "TypeID":
                       ProLb.TypeID = Convert.ToInt32(FieldValue);
                       ProductType_Ent ProType = ProductType.GetProductTypeInfo(FieldValue);
                       ProLb.TypeName = ProType.TypeName;
                       ProLb.Fields1 = ProType.Field1List;
                       ProLb.Fields2 = ProType.Field2List;
                       break;
                   case "SiteID":
                       ProLb.SiteID = Convert.ToInt32(FieldValue);
                       break;
                   case "MenuID":
                       ProLb.MenuID = Convert.ToInt32(FieldValue);
                       break;
                   case "SortNo":
                       ProLb.SortNo = Convert.ToInt32(FieldValue);
                       break;
                   case "IsTJ":
                       ProLb.IsTJ = Convert.ToInt32(FieldValue);
                       break;
                   case "Alias":
                       ProLb.Alias = FieldValue;
                       break;
                   case "MataKey":
                       ProLb.MateKey = FieldValue;
                       break;
                   case "MateDesc":
                       ProLb.MateDesc = FieldValue;
                       break;
                   case "TempID":
                       ProLb.TempID = Convert.ToInt32(FieldValue);
                       break;
               }
        }

        public static ProLBCollection Get_ProLBList(int SiteId,int MenuId,int ParentId,params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductLB where SiteID={0} and MenuID={1} and ParentID={2} order by SortNo asc", SiteId.ToString(), MenuId.ToString(), ParentId.ToString()), Fields);
            ProLBCollection ProLB_Items = new ProLBCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                ProLB_Ent item = new ProLB_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProLB_Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProLB_Items;
        }


        public static ProLBCollection Get_ProLBList(int ParentId, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductLB where ParentID={0} order by SortNo asc",  ParentId.ToString()), Fields);
            ProLBCollection ProLB_Items = new ProLBCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                ProLB_Ent item = new ProLB_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProLB_Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProLB_Items;
        }

        public static ProLB_Ent Get_ProLbInfo(int LbID, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductLB where LbID={0}", LbID.ToString()), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            ProLB_Ent item = new ProLB_Ent();
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }

        public static int Insert(string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldsValue, "ProductLB", FieldNames);
            db.Dispose();
            return r;
        }

        public static int Update(string[] FieldsValue, int LbID, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("ProductLB", "LbID", LbID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }
        /// <summary>
        /// 删除产品类别信息
        /// </summary>
        /// <param name="LbID">ProductLB表的 LbID 字段</param>
        /// <param name="DeleteSub">bool类型,是否连同子类一起删除，建议值false</param>
        /// <returns>返回删除的行数</returns>
        public static int Delete(string LbID,bool DeleteSub)
        {
            string ids = string.Empty;
            if (!DeleteSub)
            {
                ProLBCollection ProLBItem = Get_ProLBList(Convert.ToInt32(LbID), "LbID");
                if (ProLBItem.Count > 0)
                {
                    throw new Exception("对不起！当前类别有下级分类，为保证数据完整性，不能直删除。");
                }
            }
            else
            {
                GetAny_SubLbID(LbID, ref ids);
            }
            string ProParentLbids = string.Empty;
            GetAny_ParentLBID(LbID,ref ProParentLbids);
            ProductCollection ProItems = KstCmsBase.DAL.Product.Product.GetProductList(ProParentLbids, 0, "ProID");
            if (ProItems.Count > 0)
            {
                throw new Exception("对不起！当前类别存在产品信息，为保证数据完整性，不能直删除。");
            }

            ids += LbID;
            Access db = new Access();
            string WhereSql = string.Empty;
            if (ids.IndexOf(",") != -1)
            {
                foreach (string str in ids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries))
                {
                    string lbimg = db.getFieldValue(string.Format("select LbIMG from ProductLB where LbID={0}", str));
                    if (!string.IsNullOrEmpty(lbimg) && lbimg != "")
                        if (System.IO.File.Exists(System.Web.HttpContext.Current.Server.MapPath(lbimg)))
                            System.IO.File.Delete(System.Web.HttpContext.Current.Server.MapPath(lbimg));
                }
                WhereSql = "LbID in(" + ids + ")";
            }
            else
            {
                string lbimg = db.getFieldValue(string.Format("select LbIMG from ProductLB where LbID={0}", LbID));
                if (!string.IsNullOrEmpty(lbimg) && lbimg != "")
                    if (System.IO.File.Exists(System.Web.HttpContext.Current.Server.MapPath(lbimg)))
                        System.IO.File.Delete(System.Web.HttpContext.Current.Server.MapPath(lbimg));
                WhereSql = "LbID=" + LbID;
            }
            int r = db.ExecuteSql(string.Format("delete from ProductLB where {0}", WhereSql));
            db.Dispose();
            return r;
        }

        /// <summary>
        /// 取当前LbID下的所有子类别，返回格式如："1,12,32," 返回后注意需要处理最后一个","号
        /// </summary>
        /// <param name="CurrentLBID">前LbID</param>
        /// <param name="ids">返回所有下级LbID,式如："1,12,32," 返回后注意需要处理最后一个","号</param>
        private static void GetAny_SubLbID(string CurrentLBID,ref string ids)
        {
            ProLBCollection ProLBItem = Get_ProLBList(Convert.ToInt32(CurrentLBID), "LbID");
            foreach (ProLB_Ent item in ProLBItem)
            {
                ids += item.LbID.ToString() + ",";
                GetAny_SubLbID(item.LbID.ToString(), ref ids);
            }

        }
        /// <summary>
        /// 获取当前LbID所处ProductLB表中字段的位置，取得的LbID值以","隔开
        /// </summary>
        /// <param name="CurrentLBID">当前LbID</param>
        /// <param name="ids">返回LbID深度层次，以","隔开表示，如返回"1,12,20".</param>
        public static void GetAny_ParentLBID(string CurrentLBID, ref string ids)
        {
            int Pid = Get_ProLbInfo(Convert.ToInt32(CurrentLBID), "ParentID").ParentID;
            if (Pid == 0)
            {
                ids = CurrentLBID + ids;
                return;
            }
            ids = "," + CurrentLBID + ids;
            GetAny_ParentLBID(Pid.ToString(), ref ids);
        }

        /// <summary>
        /// 处理当前产品类别级别层次字符串，层次间没有超链接，如:产品类别1/产品类别2
        /// </summary>
        /// <param name="CurrentLBID">当前产品类别ID</param>
        /// <param name="Path"></param>
        public static void Get_LBPATH(string CurrentLBID,ref string Path)
        {
            KstCmsBase.Entities.Product.ProLB_Ent lb=Get_ProLbInfo(Convert.ToInt32(CurrentLBID), "ParentID","LbName");
            int Pid = lb.ParentID;
            string LbName = lb.LbName;
            if (Pid == 0)
            {
                Path = LbName  + Path;
                return;
            }
            Path = "/" + LbName + Path;
            Get_LBPATH(Pid.ToString(), ref Path);
        }
        /// <summary>
        /// 产品类别层级连接，应用于产品列表时，你的位置
        /// </summary>
        /// <param name="CurrentLBID">当前产品类别ID</param>
        /// <param name="UrlFile">链接的文件名</param>
        /// <param name="ExectueHtml">是否动态网页 1为静态</param>
        /// <param name="Path"></param>
        public static void Get_LBUrlPATH(string CurrentLBID,string UrlFile,int ExectueHtml, ref string Path)
        {
            string ClassId = string.Empty;
            if (ExectueHtml != 1)
                GetAny_ParentLBID(CurrentLBID, ref ClassId);  //取当前类别ID的层次深度位置
            KstCmsBase.Entities.Product.ProLB_Ent lb = Get_ProLbInfo(Convert.ToInt32(CurrentLBID), "ParentID", "LbName");
            int Pid = lb.ParentID;
            string LbName = lb.LbName;
            if (Pid == 0)
            {
                if (ExectueHtml == 1)
                    Path = "<a href=\"" + UrlFile + "\">" + LbName + "</a>" + Path;
                else
                    Path = "<a href=\"" + UrlFile + "&ClassId=" + ClassId + "\">" + LbName + "</a>" + Path;
                return;
            }
            if (ExectueHtml == 1)
                Path = " / <a href=\"" + UrlFile + "\">" + LbName + "</a>" + Path;
            else
                Path = " / <a href=\"" + UrlFile + "&ClassId=" + ClassId + "\">" + LbName + "</a>" + Path;
            Get_LBUrlPATH(Pid.ToString(), UrlFile, ExectueHtml, ref Path);
        }


        public static bool HasSublb(string CurrentLBID)
        {
            bool Result = Get_ProLBList(Convert.ToInt32(CurrentLBID), "LbID").Count > 0 ? true : false;
            return Result;
        }



    }
}
