﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection.Product;
using KstCmsBase.Entities.Product;


namespace KstCmsBase.DAL.Product
{
    public class Product
    {
        public static void GetField(DataRow row, string FieldName, ref Product_Ent Product)
        {
            string FieldValue = row[FieldName].ToString();
            switch (FieldName)
            {
                case "ProID":
                    Product.ProID = Convert.ToInt32(FieldValue);
                    Product.PostFieldItems = GetPostFieldList(FieldValue);
                    Product.DescFieldItems = GetDescFieldList(FieldValue);
                    break;
                case "SiteID":
                    Product.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "MenuID":
                    Product.MenuID = Convert.ToInt32(FieldValue);
                    break;
                case "LbID":
                    Product.LbID = FieldValue;
                    string Id = Product.LbID;
                    if (Product.LbID.IndexOf(",") != -1)
                        Id = FieldValue.Substring(0, Product.LbID.Length-1);
                    if (Id.IndexOf(",") != -1)
                        Id = Id.Substring(Id.LastIndexOf(",") + 1);
                    Product.TypeID = ProLB.Get_ProLbInfo(Convert.ToInt32(Id), "TypeID").TypeID;
                    break;
                case "ProNo":
                    Product.ProNo = FieldValue;
                    break;
                case "ProName":
                    Product.ProName = FieldValue;
                    break;
                case "Pic1":
                    Product.Pic1 = FieldValue;
                    break;
                case "Pic2":
                    Product.Pic2 = FieldValue;
                    break;
                case "Pic3":
                    Product.Pic3 = FieldValue;
                    break;
                case "ProDoc":
                    Product.ProDoc = FieldValue;
                    break;
                case "uTime":
                    Product.uTime = Convert.ToDateTime(FieldValue);
                    break;
                case "IsNew":
                    Product.IsNew = Convert.ToInt32(FieldValue);
                    break;
                case "IsTj":
                    Product.IsTj = Convert.ToInt32(FieldValue);
                    break;
                case "IsHot":
                    Product.IsHot = Convert.ToInt32(FieldValue);
                    break;
                case "SortNo":
                    Product.SortNo = Convert.ToInt32(FieldValue);
                    break;
                case "MateKey":
                    Product.MateKey = FieldValue;
                    break;
                case "MateDesc":
                    Product.MateDesc = FieldValue;
                    break;
                case "FileName":
                    Product.FileName = FieldValue;
                    break;
                case "TempID":
                    Product.TempID = Convert.ToInt32(FieldValue);
                    break;
            }
        }
        public static ProductCollection GetProductList(string ClassId=null, int AttRib = 0, params string[] Fields)
        {
            Access db = new Access();
            string sql = string.Empty;
            if (ClassId != null)
            {
                if (ClassId.IndexOf(",") != -1)
                {
                    sql = string.Format("from Products where LbID like '{0}%'", ClassId);
                }
                else
                {
                    sql = string.Format("from Products where LbID like '{0},%'", ClassId);

                }
            }
            else
            {
                sql = "from Products";
            }
                switch (AttRib)
                {
                    case 1:
                        sql += " and IsNew=1";
                        break;
                    case 2:
                        sql += " and IsTj=1";
                        break;
                    case 3:
                        sql += " and IsHot=1";
                        break;
                }
                sql += " order by SortNo desc";
            sql = db.Get_DbSQL(sql, Fields);
            ProductCollection ProItems = new ProductCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                Product_Ent item = new Product_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProItems.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProItems;


        }
        public static ProductCollection GetProductList(int SiteId, string KeyWork = null, int AttRib = 0, params string[] Fields)
        {
            string sql = string.Format("from Products where SiteId={0}", SiteId);
            if (KeyWork != null)
                sql += string.Format(" and ProNo like '%{0}%' or ProName like '%{1}%'", KeyWork, KeyWork);
            switch (AttRib)
            {
                case 1:
                    sql += " and IsNew=1";
                    break;
                case 2:
                    sql += " and IsTj=1";
                    break;
                case 3:
                    sql += " and IsHot=1";
                    break;
            }
            sql += " order by SortNo desc";
            Access db = new Access();
            sql = db.Get_DbSQL(sql, Fields);
            ProductCollection ProItems = new ProductCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                Product_Ent item = new Product_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProItems.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProItems;
        }
        public static ProductCollection GetProductList(int SiteId, int MenuId, string KeyWork = null, int AttRib = 0, params string[] Fields)
        {
            string sql = string.Format("from Products where SiteId={0} and MenuID={1}", SiteId, MenuId);
            if (KeyWork != null)
                sql += string.Format(" and ProNo like '%{0}%' or ProName like '%{1}%'", KeyWork, KeyWork);
            switch (AttRib)
            {
                case 1:
                    sql += " and IsNew=1";
                    break;
                case 2:
                    sql += " and IsTj=1";
                    break;
                case 3:
                    sql += " and IsHot=1";
                    break;
            }
            sql += " order by SortNo desc";
            Access db = new Access();
            sql = db.Get_DbSQL(sql, Fields);
            ProductCollection ProItems = new ProductCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                Product_Ent item = new Product_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProItems.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProItems;
        }
        public static ProductCollection GetProductList(string ClassId,int SiteId,int MenuId,int AttRib, params string[] Fields)
        {
            Access db = new Access();
            string sql = string.Empty;
            if (ClassId != null)
            {
                if (ClassId.IndexOf(",") != -1)
                {
                    sql = string.Format("from Products where LbID like '{0}%'", ClassId);
                }
                else
                {
                    sql = string.Format("from Products where LbID like '{0},%'", ClassId);

                }
            }
            else
            {
                sql = string.Format("from Products where SiteID={0}", SiteId.ToString());
                if (MenuId != 0) sql += " and MenuID=" + MenuId;
            }
            switch (AttRib)
            {
                case 1:
                    sql += " and IsNew=1";
                    break;
                case 2:
                    sql += " and IsTj=1";
                    break;
                case 3:
                    sql += " and IsHot=1";
                    break;
            }
            sql += " order by SortNo desc";
            sql = db.Get_DbSQL(sql, Fields);
            ProductCollection ProItems = new ProductCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                Product_Ent item = new Product_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProItems.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProItems;


        }
        public static ProductCollection GetProductList(int SiteId, int MenuId, int ProNum, int AttRib = 0, params string[] Fields)
        {
            string sql = string.Format("from Products where SiteId={0} and MenuID={1}", SiteId, MenuId);
            switch (AttRib)
            {
                case 1:
                    sql += " and IsNew=1";
                    break;
                case 2:
                    sql += " and IsTj=1";
                    break;
                case 3:
                    sql += " and IsHot=1";
                    break;
            }
            sql += " order by SortNo desc";
            Access db = new Access();
            sql = db.Get_DbSQL(sql, ProNum, Fields);
            ProductCollection ProItems = new ProductCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                Product_Ent item = new Product_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProItems.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProItems;
        }
        public static ProductCollection GetProductList(string ClassId,int SiteId, int MenuId, int ProNum, int AttRib = 0, params string[] Fields)
        {
            string sql = string.Format("from Products where SiteId={0} and MenuID={1}", SiteId, MenuId);
            if (!string.IsNullOrEmpty(ClassId))
            {
                if (ClassId.IndexOf(",") != -1)
                    sql += string.Format(" and LbID like '{0}%'", ClassId);
                else
                    sql += string.Format(" and LbID like '{0},%'", ClassId);
            }
            switch (AttRib)
            {
                case 1:
                    sql += " and IsNew=1";
                    break;
                case 2:
                    sql += " and IsTj=1";
                    break;
                case 3:
                    sql += " and IsHot=1";
                    break;
            }
            sql += " order by SortNo desc";
            Access db = new Access();
            sql = db.Get_DbSQL(sql, ProNum, Fields);
            ProductCollection ProItems = new ProductCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow Row in dsData.Tables[0].Rows)
            {
                Product_Ent item = new Product_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(Row, FieldName, ref item);
                }
                ProItems.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return ProItems;
        }

        public static Product_Ent GetProductInfo(int ProId, params string[] Fields)
        {
            string sql = string.Format("from Products where ProID={0}", ProId);
            Access db = new Access();
            sql=db.Get_DbSQL(sql, Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            Product_Ent item = new Product_Ent();
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }

        public static int Product_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r=db.DataInsert(data, "Products", Fields);
            db.Dispose();
            return r;
        }

        public static int Product_Update(string[] data,int loadID, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("Products", "ProID", loadID, data, Fields);
            db.Dispose();
            return r;
        }

        public static PostFieldCollection GetPostFieldList(string ProID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from PostField where ProID={0}", ProID));
            PostFieldCollection PostFieldItems = new PostFieldCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                PostField_Ent Field = new PostField_Ent();
                Field.PostID = Convert.ToInt32(dr["PostID"].ToString());
                Field.ProID = Convert.ToInt32(dr["ProID"].ToString());
                Field.FieldName = dr["FieldName"].ToString();
                Field.FieldValue = dr["FieldValue"].ToString();
                Field.InputType = Convert.ToInt32(dr["InputType"].ToString());
                PostFieldItems.Add(Field);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return PostFieldItems;
        }

        public static DescFieldCollection GetDescFieldList(string ProID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from DescField where ProID={0}", ProID));
            DescFieldCollection DescFieldItems = new DescFieldCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                DescField_Ent Field = new DescField_Ent();
                Field.DescID = Convert.ToInt32(dr["DescID"].ToString());
                Field.ProID = Convert.ToInt32(dr["ProID"].ToString());
                Field.FieldName = dr["FieldName"].ToString();
                Field.FieldValue = dr["FieldValue"].ToString();
                DescFieldItems.Add(Field);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return DescFieldItems;
        }

        public static int PostField_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "PostField", Fields);
            db.Dispose();
            return r;
        }

        public static int PostField_Update(string[] data, int loadID, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("PostField", "PostID", loadID, data, Fields);
            db.Dispose();
            return r;
        }

        public static int PostField_Update(string[] data,string IndexField, int IndexFieldValue, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("PostField", IndexField, IndexFieldValue, data, Fields);
            db.Dispose();
            return r;
        }

        public static int DescField_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "DescField", Fields);
            db.Dispose();
            return r;
        }

        public static int DescField_Update(string[] data,int loadID, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("DescField", "DescID", loadID, data, Fields);
            db.Dispose();
            return r; 
        }

        public static int DescField_Update(string[] data, string IndexField,int IndexFieldValue, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("DescField", IndexField, IndexFieldValue, data, Fields);
            db.Dispose();
            return r;
        }

        public static int Products_delete(string[] ProIds)
        {
            Access db = new Access();
            int r = 0;
            for (int i = 0; i < ProIds.Length; i++)
            {
                KstCmsBase.Entities.Product.Product_Ent p = GetProductInfo(Convert.ToInt32(ProIds[i]), "Pic1", "Pic2", "Pic3");
                r += db.DataDelete("PostField", "ProID", Convert.ToInt32(ProIds[i]));
                r += db.DataDelete("DescField", "ProID", Convert.ToInt32(ProIds[i]));
                r += ProductFile_delete(ProIds[i]);
                r += ProductPic_delete(ProIds[i]);
                r += db.DataDelete("Products", "ProID", Convert.ToInt32(ProIds[i]));
                try
                {
                    if (System.IO.File.Exists(System.Web.HttpContext.Current.Server.MapPath(p.Pic1)))
                        System.IO.File.Delete(System.Web.HttpContext.Current.Server.MapPath(p.Pic1));
                    if (System.IO.File.Exists(System.Web.HttpContext.Current.Server.MapPath(p.Pic2)))
                        System.IO.File.Delete(System.Web.HttpContext.Current.Server.MapPath(p.Pic2));
                    if (System.IO.File.Exists(System.Web.HttpContext.Current.Server.MapPath(p.Pic3)))
                        System.IO.File.Delete(System.Web.HttpContext.Current.Server.MapPath(p.Pic3));
                }
                catch (Exception err)
                {
                    throw new Exception(err.Message);
                }
                finally
                {
                   
                }
 
            }
            db.Dispose();
            return r;
        }

        public static int ProductFile_delete(string ProID)
        {
            Access db = new Access();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(string.Format("select FilePath from ProductFile where ProID={0}", ProID));
            try
            {
                while (dr.Read())
                {
                    string PathFile = System.Web.HttpContext.Current.Server.MapPath(dr["FilePath"].ToString());
                    if (System.IO.File.Exists(PathFile))
                        System.IO.File.Delete(PathFile);
                }
            }
            finally
            {
                dr.Close(); dr.Dispose();
                
            }
            int r = db.DataDelete("ProductFile", "ProID", Convert.ToInt32(ProID));
            db.Dispose();
            return r;
        }


        public static int ProductFile_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "ProductFile", Fields);
            db.Dispose();
            return r;
        }

        public static int ProductFile_Update(string IndexField, int IndexValue, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("ProductFile", IndexField, IndexValue, data, Fields);
            db.Dispose();
            return r;
        }


        public static int ProductPic_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "ProductPic", Fields);
            db.Dispose();
            return r;
        }

        public static int ProductPic_Update(string IndexField,int IndexValue,string[] data,params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("ProductPic", IndexField, IndexValue, data, Fields);
            db.Dispose();
            return r;
        }

        public static int ProductFile_delete(int DownID)
        {
            Access db = new Access();
            string FilePath = db.getFieldValue(string.Format("select FilePath from ProductFile where DownID={0}", DownID.ToString()));
            db.Dispose();
            FilePath = System.Web.HttpContext.Current.Server.MapPath(FilePath);
            try
            {
                if (System.IO.File.Exists(FilePath))
                    System.IO.File.Delete(FilePath);
            }
            finally
            {

            }
            int r = db.DataDelete("ProductFile", "DownID", DownID);
            db.Dispose();
            return r;
        }


        public static int ProductPic_delete(string ProID)
        {
            Access db = new Access();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(string.Format("select Pic1,Pic2,Pic3 from ProductPic where ProID={0}", ProID));
            try
            {
                while (dr.Read())
                {
                    string Pic1 = System.Web.HttpContext.Current.Server.MapPath(dr["Pic1"].ToString());
                    string Pic2 = System.Web.HttpContext.Current.Server.MapPath(dr["Pic2"].ToString());
                    string Pic3 = System.Web.HttpContext.Current.Server.MapPath(dr["Pic3"].ToString());
                    if (System.IO.File.Exists(Pic1))
                        System.IO.File.Delete(Pic1);
                    if (System.IO.File.Exists(Pic2))
                        System.IO.File.Delete(Pic2);
                    if (System.IO.File.Exists(Pic3))
                        System.IO.File.Delete(Pic3);
                }
            }
            finally
            {
                dr.Close(); dr.Dispose();

            }
            int r = db.DataDelete("ProductPic", "ProID", Convert.ToInt32(ProID));
            db.Dispose();
            return r;
        }

        public static int ProductPic_delete(int PicID)
        {
            Access db = new Access();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(string.Format("select Pic1,Pic2,Pic3 from ProductPic where PicID={0}", PicID.ToString()));
            string Pic1 = string.Empty;
            string Pic2 = string.Empty;
            string Pic3 = string.Empty;
            if (dr.Read())
            {
                Pic1 = System.Web.HttpContext.Current.Server.MapPath(dr["Pic1"].ToString());
                Pic2 = System.Web.HttpContext.Current.Server.MapPath(dr["Pic2"].ToString());
                Pic3 = System.Web.HttpContext.Current.Server.MapPath(dr["Pic3"].ToString());
            }
            dr.Close();
            dr.Dispose();
            try
            {
                if (!string.IsNullOrEmpty(Pic1) && !string.IsNullOrEmpty(Pic2))
                {
                    if (System.IO.File.Exists(Pic1))
                        System.IO.File.Delete(Pic1);
                    if (System.IO.File.Exists(Pic2))
                        System.IO.File.Delete(Pic2);
                    if (System.IO.File.Exists(Pic3))
                        System.IO.File.Delete(Pic3); 
                }
            }
            finally
            {

            }
            int r = db.DataDelete("ProductPic", "PicID", PicID);
            db.Dispose();
            return r;
        }



        public static ProductFileCollection GetProductFiles(string ProID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductFile where ProID={0} order by SortNo asc", ProID));
            ProductFileCollection FileItems = new ProductFileCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                ProductFile_Ent item = new ProductFile_Ent();
                item.DownID = Convert.ToInt32(dr["DownID"].ToString());
                item.ProID = Convert.ToInt32(dr["ProID"].ToString());
                item.FileName = dr["FileName"].ToString();
                item.FilePath = dr["FilePath"].ToString();
                item.FileSize=Convert.ToInt32(dr["FileSize"].ToString());
                item.uTime = Convert.ToDateTime(dr["uTime"].ToString());
                item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                FileItems.Add(item);
            }
            db.Dispose();
            return FileItems;
        }

        public static ProductPicCollection GetProductPics(string ProID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductPic where ProID={0} order by SortNo asc", ProID));
            ProductPicCollection PicItems = new ProductPicCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                ProductPic_Ent item = new ProductPic_Ent();
                item.PicID = Convert.ToInt32(dr["PicID"].ToString());
                item.ProID = Convert.ToInt32(dr["ProID"].ToString());
                item.PicName = dr["PicName"].ToString();
                item.Pic1 = dr["Pic1"].ToString();
                item.Pic2 = dr["Pic2"].ToString();
                item.Pic3 = dr["Pic3"].ToString();
                item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                PicItems.Add(item);
            }
            db.Dispose();
            return PicItems;
        }

        public static int ProductCopyTo(string[] ProIds,string ToSiteID,string ToMenuId,string ToLBID)
        {
            Access db = new Access();
            int r = 0;
            try
            {
                for (int i = 0; i < ProIds.Length; i++)
                {
                    Product_Ent Product = GetProductInfo(Convert.ToInt32(ProIds[i]));
                    if (ToLBID == Product.LbID)
                        continue;
                    string[] data = new string[]{
                    ToSiteID,
                    ToMenuId,
                    ToLBID,
                    Product.ProNo,
                    Product.ProName,
                    Product.Pic1,
                    Product.Pic2,
                    Product.Pic3,
                    Product.ProDoc,
                    Product.uTime.ToString(),
                    Product.IsNew.ToString(),
                    Product.IsTj.ToString(),
                    Product.IsHot.ToString(),
                    Product.SortNo.ToString(),
                    Product.MateKey,
                    Product.MateDesc,
                    Product.FileName
                };
                    int n = Product_Insert(data, "SiteID", "MenuID", "LbID", "ProNo", "ProName", "Pic1", "Pic2", "Pic3", "ProDoc", "uTime", "IsNew", "IsTj", "IsHot", "SortNo", "MateKey", "MateDesc", "FileName");
                    string NewProID = db.getFieldValue("select max(ProID) as ID from Products");
                    r += n;
                }

            }
            catch (Exception err)
            {
                throw new Exception(err.Message);
            }
            finally
            {
                db.Dispose();
            }

            return r;
        }

        public static int ProductMoveTo(string[] ProIds, string ToSiteID, string ToMenuId, string ToLBID)
        {
            Access db = new Access();
            int r = 0;
            for (int i = 0; i < ProIds.Length; i++)
            {
                Product_Ent Product = GetProductInfo(Convert.ToInt32(ProIds[i]));
                if (ToLBID == Product.LbID)
                    continue;
                string[] data = new string[]{
                   
                    ToSiteID,
                    ToMenuId,
                    ToLBID,
                    Product.ProNo,
                    Product.ProName,
                    Product.Pic1,
                    Product.Pic2,
                    Product.Pic3,
                    Product.ProDoc,
                    Product.uTime.ToString(),
                    Product.IsNew.ToString(),
                    Product.IsTj.ToString(),
                    Product.IsHot.ToString(),
                    Product.SortNo.ToString(),
                    Product.MateKey,
                    Product.MateDesc,
                    Product.FileName
                };
                r += Product_Update(data, Product.ProID, "SiteID", "MenuID", "LbID", "ProNo", "ProName", "Pic1", "Pic2", "Pic3", "ProDoc", "uTime", "IsNew", "IsTj", "IsHot", "SortNo", "MateKey", "MateDesc", "FileName");
            }

            db.Dispose();
            return r;
        }

    }
}
