﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Entities;
using KstCmsBase.Collection;

namespace KstCmsBase.DAL
{
    public class Role
    {
        public static RoleEntity Get_RoleInfo(int RoleId)
        {
            RoleEntity Role = new RoleEntity();
            Access db = new Access();
            string sql = string.Format("select * from Role where RoleId={0}", RoleId.ToString());
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                Role.RoleId = RoleId;
                Role.RoleName = dr["RoleName"].ToString();
                Role.RunCode = dr["RunCode"].ToString();

            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Role;
        }

        public static RoleCollection Get_RoleList()
        {
            RoleCollection items = new RoleCollection();
            Access db = new Access();
            string sql = "select * from Role";
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                RoleEntity item = new RoleEntity();
                item.RoleId = Convert.ToInt32(dr["RoleId"].ToString());
                item.RoleName = dr["RoleName"].ToString();
                item.RunCode = dr["RunCode"].ToString();
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }

        public static int Role_Insert(string[] FieldsValue,params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldsValue, "Role", FieldNames);
            db.Dispose();
            return r;
        }

        public static int Role_Update(string[] FieldsValue, int loadID, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("Role", "RoleId", loadID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }


        /// <summary>
        /// 复制角色
        /// </summary>
        /// <param name="RoleInfo"></param>
        /// <returns></returns>
        public static int Copy(RoleEntity RoleInfo)
        {
            Access db = new Access();
            string SqlStr = "insert into Role(RoleName,RunCode) values(@RoleName,@RunCode)";
            System.Data.OleDb.OleDbCommand cmd = new System.Data.OleDb.OleDbCommand(SqlStr, db.dbconn);
            cmd.Parameters.Add("@RoleName", System.Data.OleDb.OleDbType.VarChar, 50).Value = RoleInfo.RoleName;
            cmd.Parameters.Add("@RunCode", System.Data.OleDb.OleDbType.LongVarChar).Value = RoleInfo.RunCode;
            int r = 0;
            try
            {
                r = cmd.ExecuteNonQuery();
            }
            catch (Exception e)
            {
                throw new Exception(e.Message);
            }
            finally
            {
                cmd.Dispose();
                db.Dispose();
            }
            return r;
        }

        /// <summary>
        /// 设置角色可用的菜单，即权限
        /// </summary>
        /// <param name="RoleInfo"></param>
        /// <returns></returns>
        public static int SetPermissions(RoleEntity RoleInfo)
        {
            string SqlStr = "update Role set RunCode=@RunCode where RoleId=" + RoleInfo.RoleId.ToString();
            Access db = new Access();
            System.Data.OleDb.OleDbCommand cmd = new System.Data.OleDb.OleDbCommand(SqlStr, db.dbconn);
            
            int r = 0;

            try
            {
                cmd.Parameters.Add("@RunCode", System.Data.OleDb.OleDbType.LongVarChar).Value = RoleInfo.RunCode;
                r = cmd.ExecuteNonQuery();
            }
            catch (Exception e)
            {
                throw new Exception(e.Message);
            }
            finally
            {
                cmd.Dispose();
                db.Dispose();
            }
            return r;
        }

        /// <summary>
        /// 删除角色
        /// </summary>
        /// <param name="RoleId"></param>
        /// <returns></returns>
        public static int Delete(int RoleId)
        {
            int r = 0;
            Access db = new Access();
            if (Users.Get_UserList(RoleId.ToString()).Count != 0)
            {
                throw new Exception("对不起，该角色包含着一些用户，不能删除！");

            }
            r = db.DataDelete("Role", "RoleId", RoleId);
            db.Dispose();
            return r;
        }

        /// <summary>
        /// 比较两个角色中是否有相同的角色
        /// </summary>
        /// <param name="SouceRoleId">被比较的角色</param>
        /// <param name="TagRoleId"></param>
        /// <returns></returns>
        public static bool CheckQx(string SouceRoleId, string TagRoleId)
        {
            bool Result = false;
            if (string.IsNullOrEmpty(SouceRoleId) || string.IsNullOrEmpty(TagRoleId)) return Result;

            if (SouceRoleId == TagRoleId)
            {
                Result = true;
            }
            else
            {
                if (TagRoleId.IndexOf(SouceRoleId) != -1)
                {
                    Result = true;
                }
                else
                {
                    string[] s = SouceRoleId.Split(',');
                    for (int i = 0; i < s.Length; i++)
                    {
                        if (string.IsNullOrEmpty(s[i].Trim()))
                            continue;
                        if (TagRoleId.IndexOf(s[i].Trim()) != -1)
                        {
                            Result = true;
                            break;
                        }
                    }
                }
            }
            return Result;
        }
    }
}
