﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection.Tag;
using KstCmsBase.Entities.Tag;

namespace KstCmsBase.DAL.Tag
{
    public class TagTEMP
    {
        public static TagTempCollection GetTagTempItems(int TagLBID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from TempTAG where TagLbID={0}", TagLBID.ToString()));
            TagTempCollection items = new TagTempCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                TagTEMP_ent item = new TagTEMP_ent();
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLbID = Convert.ToInt32(dr["TagLbID"].ToString());
                item.TagName = dr["TagName"].ToString();
                item.ContentTAG = dr["ContentTAG"].ToString();
                item.ListTAG = dr["ListTAG"].ToString();
                item.TitleLEN = Convert.ToInt32(dr["TitleLEN"].ToString());
                item.DocLEN = Convert.ToInt32(dr["DocLEN"].ToString());
                item.UtimeFormat = Convert.ToInt32(dr["UtimeFormat"].ToString());
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }
        public static TagTEMP_ent Get_TagTEMP(int TagID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from TempTAG where TagID={0}", TagID.ToString()));
            TagTEMP_ent item = new TagTEMP_ent();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLbID = Convert.ToInt32(dr["TagLbID"].ToString());
                item.TagName = dr["TagName"].ToString();
                item.ContentTAG = dr["ContentTAG"].ToString();
                item.ListTAG = dr["ListTAG"].ToString();
                item.TitleLEN = Convert.ToInt32(dr["TitleLEN"].ToString());
                item.DocLEN = Convert.ToInt32(dr["DocLEN"].ToString());
                item.UtimeFormat = Convert.ToInt32(dr["UtimeFormat"].ToString());
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static TagTempLBCollection TagTempLBItems()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from TagLBID");
            TagTempLBCollection items = new TagTempLBCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                TagTEMPLB_ent item = new TagTEMPLB_ent();
                item.TagLBID = Convert.ToInt32(dr["TagLBID"].ToString());
                item.TagLBNAME = dr["TagLBNAME"].ToString();
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }

        public static int TagLB_insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "TagLBID", Fields);
            db.Dispose();
            return r;
        }

        public static int TagLB_Update(int loadID, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("TagLBID", "TagLBID", loadID, data, Fields);
            db.Dispose();
            return r;
        }

        public static int TagLB_Delete(int loadID)
        {
            Access db = new Access();
            if (GetTagTempItems(loadID).Count > 0)
            {
                db.Dispose();
                throw new Exception("操作错误！,此类型中存在签标！");
            }
            int r = db.DataDelete("TagLBID", "TagLBID", loadID);
            db.Dispose(); return r;
        }

        public static int TagTemp_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "TempTAG", Fields);
            db.Dispose();
            return r;
        }

        public static int TagTemp_Update(int loadID, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("TempTAG", "TagID", loadID, data, Fields);
            db.Dispose();
            return r;
        }
        public static int TagTemp_Delete(int loadID)
        {
            Access db = new Access();
            int r = db.DataDelete("TempTAG", "TagID", loadID);
            db.Dispose();
            return r;
        }


        public static VarLBTAGCollection GetVarLBTAGCollection()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from VarTAGLB");
            VarLBTAGCollection Items = new VarLBTAGCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                VarLBTAG item = new VarLBTAG();
                item.VarLBID = Convert.ToInt32(dr["VarLBID"].ToString());
                item.VarNAME = dr["VarNAME"].ToString();
                Items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }
        public static VarLBTAG GetVarLBTAG(int VarLBID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from VarTAGLB where VarLBID={0}", VarLBID.ToString()));
            VarLBTAG item = new VarLBTAG();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.VarLBID = Convert.ToInt32(dr["VarLBID"].ToString());
                item.VarNAME = dr["VarNAME"].ToString();
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }
        public static int VarLBTAG_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "VarTAGLB", Fields);
            db.Dispose();
            return r;
        }

        public static int VarLBTAG_Update(int loadID, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("VarTAGLB", "VarLBID", loadID, data, Fields);
            db.Dispose();
            return r;
        }

        public static int VarLBTAG_Delete(int loadID)
        {
            Access db = new Access();
            if (GetVarTAGCollection(loadID).Count > 0)
            {
                db.Dispose();
                throw new Exception("操作错误！,此类型中存在签标！");
            }
            int r = db.DataDelete("VarTAGLB", "VarLBID", loadID);
            db.Dispose(); return r;
        }

        public static VarTAGCollection GetVarTAGCollection(int VarLBID=0)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from VarTAG where TagLBID={0}", VarLBID.ToString()));
            if (VarLBID == 0)
                sql = db.Get_DbSQL(string.Format("from VarTAG"));
            VarTAGCollection Items = new VarTAGCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                VarTAG_ent item = new VarTAG_ent();
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLBID = Convert.ToInt32(dr["TagLBID"].ToString());
                item.TagName = dr["TagName"].ToString();
                item.VarTAG = dr["VarTAG"].ToString();
                item.TagContent = dr["TagContent"].ToString();
                Items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }
        public static VarTAG_ent GetVarTAG(int TagID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from VarTAG where TagID={0}", TagID.ToString()));
            VarTAG_ent item = new VarTAG_ent();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
               
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLBID = Convert.ToInt32(dr["TagLBID"].ToString());
                item.TagName = dr["TagName"].ToString();
                item.VarTAG = dr["VarTAG"].ToString();
                item.TagContent = dr["TagContent"].ToString();
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static int VarTAG_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "VarTAG", Fields);
            db.Dispose();
            return r;
        }
        public static int VarTAG_Update(int loadID, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("VarTAG", "TagID", loadID, Data, Fields);
            db.Dispose();
            return r;    
        }
        public static int VarTAG_Delete(int TagID)
        {
            Access db = new Access();
            int r = db.DataDelete("VarTAG", "TagID", TagID);
            db.Dispose(); return r;
        }


        public static TagDescCollection Get_TagDescItems(int LbID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from DescTAG where LBID={0}", LbID.ToString()));
            TagDescCollection Items = new TagDescCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                TagDESC_ent item = new TagDESC_ent();
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLbID = LbID;
                item.TagName = dr["TagName"].ToString();
                item.ContentTAG = dr["DescTAG"].ToString();
                Items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }

        public static TagDESC_ent Get_TagDESC(int TagId)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from DescTAG where TagID={0}", TagId.ToString()));
            TagDESC_ent item = new TagDESC_ent();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLbID = Convert.ToInt32(dr["LBID"].ToString());
                item.TagName = dr["TagName"].ToString();
                item.ContentTAG = dr["DescTAG"].ToString();
                item.uTimeFormat = Convert.ToInt32(dr["uTimeFormat"].ToString());
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static int TagDESC_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "DescTAG", Fields);
            db.Dispose();
            return r;
        }

        public static int TagDESC_Update(int TagID, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("DescTAG", "TagID", TagID, Data, Fields);
            db.Dispose();
            return r;
        }

        public static int TagDESC_Delete(int TagID)
        {
            Access db = new Access();
            int r = db.DataDelete("DescTAG", "TagID", TagID);
            db.Dispose();
            return r;
        }

        public static TagDescLBCollection Get_TagDescLBItems()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from DescTAGLB");
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            TagDescLBCollection Items = new TagDescLBCollection();
            while (dr.Read())
            {
                TagDESCLB_ent item = new TagDESCLB_ent();
                item.LBID = Convert.ToInt32(dr["LBID"].ToString());
                item.LBNAME = dr["LBNAME"].ToString();
                Items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }

        public static int TagDescLB_delete(int LbID)
        {
            TagDescCollection TagDescItems = Get_TagDescItems(LbID);
            if (TagDescItems.Count > 0)
                throw new Exception("操作错误，此类存在内容标签，不能直接删除！");
            Access db = new Access();
            int r = db.DataDelete("DescTAGLB", "LBID", LbID);
            db.Dispose();
            return r;
        }

        public static int TagDescLB_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "DescTAGLB", Fields);
            db.Dispose();
            return r;
        }

        public static int TagDescLB_Update(int LbId, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("DescTAGLB", "LBID", LbId, Data, Fields);
            db.Dispose();
            return r;
        }

    }
}
