﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Entities;
using KstCmsBase.Collection;

namespace KstCmsBase.DAL
{
    public class Users
    {
        private static void GetField(DataRow Row, string FieldName, ref UsersEntity Users)
        {
            
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "UserId":
                    Users.UserId = FieldValue;
                    break;
                case "UserName":
                    Users.UserName= FieldValue;
                    break;
                case "UserPwd":
                    Users.UserPwd = FieldValue;
                    break;
                case "YourName":
                    Users.YourName = FieldValue;
                    break;
                case "Email":
                    Users.Email = FieldValue;
                    break;
                case "UserRole":
                    Users.UserRole = FieldValue;
                    if (!string.IsNullOrEmpty(FieldValue) && FieldValue != "")
                    {
                        Access db = new Access();
                        string[] R = FieldValue.Split(',');
                        for (int n = 0; n < R.Length; n++)
                        {
                            if (!string.IsNullOrEmpty(R[n].ToString()))
                                Users.RoleNameList += db.getFieldValue("select RoleName from Role where RoleId=" + R[n].ToString()) + ",";
                        }
                        db.Dispose();
                    }
                    break;
                case "isAdmin":
                    Users.isAdmin = Convert.ToInt32(FieldValue);
                    break;
                case "Act":
                    Users.Act = Convert.ToInt32(FieldValue);
                    break;
            }
        }

        public static UsersEntity Get_UserInfo(string UserName)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from Users where UserName='{0}'",UserName));
            DataSet dsData = db.ExecuteDataSet(sql.ToString());
            UsersEntity item = new UsersEntity();
           
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
               
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }

        public static Usersollection Get_UserList()
        {
           
            Access db = new Access();
            string sql = db.Get_DbSQL("from Users");
            DataSet dsData = db.ExecuteDataSet(sql);
            Usersollection items = new Usersollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                UsersEntity item = new UsersEntity();

                    for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                    {
                        string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                        GetField(row, FieldName, ref item);
                    }
                
              // if(Convert.ToInt32(row["isAdmin"].ToString())!=1)
                    items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }

        public static Usersollection Get_UserList(int RoleId)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from Users where UserRole like '%{0},%'", RoleId.ToString()));
            DataSet dsData = db.ExecuteDataSet(sql);
            Usersollection items = new Usersollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                UsersEntity item = new UsersEntity();

                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                   // items.Add(item);

                }
            //    if (Convert.ToInt32(row["isAdmin"].ToString()) != 1)
                    items.Add(item);

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }

        public static Usersollection Get_UserList(string RoleId)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from Users where UserRole like '{0},%'", RoleId));
            DataSet dsData = db.ExecuteDataSet(sql);
            Usersollection items = new Usersollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                UsersEntity item = new UsersEntity();

                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                    items.Add(item);

                }

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }

        public static int Users_Insert(string[]FieldsValue,params string[] FieldNames)
        {
            Access db = new Access();
            int r=db.DataInsert(FieldsValue, "Users", FieldNames);
            db.Dispose();
            return r;
        }

        /// <summary>
        /// 更新后台用户帐号
        /// </summary>
        /// <param name="loadID">要更新的用户ID</param>
        /// <param name="FieldsValue">将要更新的值</param>
        /// <param name="FieldNames">将要更新的字段</param>
        /// <returns></returns>
        public static int Users_Update(int loadID, string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("Users", "UserId", loadID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }


        public static Boolean Login(string UserName, string pwd)
        {
            
            UsersEntity TTUser = Get_UserInfo(UserName);
            if (TTUser.UserName == UserName && TTUser.UserPwd == pwd)
                return true;
            else
                return false;
        }

        /// <summary>
        /// 测用户是否被锁定，非活动用户，如果为真则被锁定了
        /// </summary>
        /// <param name="UserId"></param>
        /// <returns></returns>
        public static Boolean Chk_UserAct(string UserName)
        {
            UsersEntity TTUser = Get_UserInfo(UserName);
            return TTUser.Act == 1 ? true : false;
        }

        /// <summary>
        /// 锁定或激活用户
        /// </summary>
        /// <param name="UserId"></param>
        /// <returns></returns>
        public static int Set_UserAction(string UserName)
        {
            UsersEntity TTUser = Get_UserInfo(UserName);
            if (TTUser.isAdmin == 1)
            {
                return 0;
            }
            Access db = new Access();
            int Act = TTUser.Act;
            Act = Act == 1 ? 0 : 1;
            string[] Fields=new string[]{Act.ToString()};
            int r=db.DataUpdate("Users", "UserName", UserName, Fields, "Act");

            db.Dispose();
            return r;
        }

        public static int Set_UserPwd(string UserName,string MD5Pwd)
        {
            Access db = new Access();
            string[] Fields = new string[] { MD5Pwd };
            int r = db.DataUpdate("Users", "UserName", UserName, Fields, "UserPwd");
            db.Dispose();
            return r;
        }

        public static int User_Delete(string UserName)
        {
            KstCmsBase.Entities.UsersEntity TTUser = Get_UserInfo(UserName);
            if (TTUser.isAdmin == 1)
            {
                throw new Exception("对不起，您不能删除管理员帐号！");
            }
            Access db = new Access();
            int r=db.DataDelete("Users", "UserName", UserName);
            db.Dispose();
            return r;
        }




    }
}
