﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection;
using KstCmsBase.Entities;

namespace KstCmsBase.DAL
{
    public class WebLM
    {
        private static void GetField(DataRow Row, string FieldName, ref WebLm_ent WebLM)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "LmID":
                    WebLM.LmID = Convert.ToInt32(FieldValue);
                    break;
                case "SiteID":
                    WebLM.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "MenuID":
                    WebLM.MenuID = Convert.ToInt32(FieldValue);
                    break;
                case "LmName":
                    WebLM.LmName = FieldValue;
                    break;
                case "Content":
                    WebLM.Content = FieldValue;
                    break;
                case "uPageFile":
                    WebLM.uPageFile = FieldValue;
                    break;
                case "MateKey":
                    WebLM.MateKey = FieldValue;
                    break;
                case "MateDesc":
                    WebLM.MateDesc = FieldValue;
                    break;
                case "SortNo":
                    WebLM.SortNo = Convert.ToInt32(FieldValue);
                    break;
                case "Act":
                    WebLM.Act = Convert.ToInt32(FieldValue);
                    break;
                case "TempID":
                    WebLM.TempID = Convert.ToInt32(FieldValue);
                    break;
            }
        }

        public static WebLmCollection Get_LMList(int MenuID, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebLM where MenuID={0} order by SortNo asc", MenuID), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebLmCollection Items = new WebLmCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebLm_ent item = new WebLm_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }

        public static WebLmCollection Get_LMList(int SiteID,int MenuID, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebLM where SiteID={0} and MenuID={1} order by SortNo asc", SiteID,MenuID), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebLmCollection Items = new WebLmCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebLm_ent item = new WebLm_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }
        public static WebLmCollection Get_LMList(int SiteID, int MenuID,int Action, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebLM where SiteID={0} and MenuID={1} and Act={2} order by SortNo asc", SiteID, MenuID,Action), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebLmCollection Items = new WebLmCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebLm_ent item = new WebLm_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }

        public static WebLm_ent Get_WebLMInfo(int LmID, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebLM where LmID={0}", LmID), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebLm_ent item = new WebLm_ent();
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }

        public static int Insert(string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldsValue, "WebLM", FieldNames);
            db.Dispose();
            return r;
        }

        public static int Update(string[] FieldsValue, int LoadID, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("WebLM", "LmID", LoadID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }

        public static int Delete(string LoadID)
        {
            Access db = new Access();
            int r = db.DataDelete("WebLM", "LmID", Convert.ToInt32(LoadID));
            db.Dispose();
            return r;
        }



    }
}
