﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection;
using KstCmsBase.Entities;

namespace KstCmsBase.DAL
{
    public class WebSite
    {
/// <summary>
/// 取字段值
/// </summary>
/// <param name="Row"></param>
/// <param name="FieldName"></param>
/// <param name="WebSite"></param>
        private static void GetField(DataRow Row, string FieldName,ref WebSite_ent WebSite )
        {
            string FieldValue=Row[FieldName].ToString();
            switch (FieldName)
            {
                case "SiteID":
                    WebSite.SiteID = Convert.ToInt32(FieldValue); 
                    break;
                case "SiteVer":
                    WebSite.SiteVer = FieldValue;
                    break;
                case "VerName":
                    WebSite.VerName = FieldValue;
                    break;
                case "SiteName":
                    WebSite.SiteName = FieldValue;
                    break;
                case "SiteTitle":
                    WebSite.SiteTitle = FieldValue;
                    break;
                case "MateKey":
                    WebSite.MateKey = FieldValue;
                    break;
                case "MateDesc":
                    WebSite.MateDesc = FieldValue;
                    break;
                case "CopyRight":
                    WebSite.CopyRight = FieldValue;
                    break;
                case "DefaultSite":
                    WebSite.DefaultSite = Convert.ToInt32(FieldValue);
                    break;
                case "SortNO":
                    WebSite.SortNO = Convert.ToInt32(FieldValue);
                    break;
                case "SiteACT":
                    WebSite.SiteACT = Convert.ToInt32(FieldValue);
                    break;
                case "TempID":
                    WebSite.TempID = Convert.ToInt32(FieldValue);
                    break;
      
            }

        }
/// <summary>
/// 取WebSite表视图
/// </summary>
/// <param name="Fields"></param>
/// <returns></returns>
        public static WebSite_Collection Get_WebSiteList(params string[] Fields)
        {
            KstCmsBase.DAL.Access db = new Access();
            string sql = db.Get_DbSQL("from WebSite order by sortno asc", Fields);
            DataSet dsData = db.ExecuteDataSet(sql.ToString());
            WebSite_Collection Items = new WebSite_Collection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebSite_ent item = new WebSite_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;

        }

   

        public static WebSite_Collection Get_WebSiteList(int Action,params string[] Fields)
        {
            KstCmsBase.DAL.Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebSite where SiteACT={0} order by sortno asc", Action.ToString()), Fields);
            DataSet dsData = db.ExecuteDataSet(sql.ToString());
            WebSite_Collection Items = new WebSite_Collection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebSite_ent item = new WebSite_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }
/// <summary>
/// 取站点信息
/// </summary>
/// <param name="SiteId"></param>
/// <param name="Fields"></param>
/// <returns></returns>
        public static WebSite_ent Get_WebSite_Info(int SiteId, params string[] Fields)
        {
            KstCmsBase.DAL.Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebSite where SiteId={0}", SiteId.ToString()), Fields);
            DataSet dsData = db.ExecuteDataSet(sql.ToString());
            WebSite_ent item = new WebSite_ent();
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }

        public static WebSite_ent Get_DefaultSite(params string[] Fields)
        {
            KstCmsBase.DAL.Access db = new Access();
            string sql = db.Get_DbSQL("from WebSite where DefaultSite=1 and SiteACT=1", Fields);
            DataSet dsData = db.ExecuteDataSet(sql.ToString());
            WebSite_ent item = new WebSite_ent();
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }


        public static int Insert(string[] FieldsValue,params string[] FieldNames)
        {
            Access db = new Access();
            int r= db.DataInsert(FieldsValue, "WebSite", FieldNames);
            db.Dispose();
            return r;
        }

        public static int Update(string[] FieldsValue,int LoadID, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("WebSite", "SiteID", LoadID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }

        public static int Delete(string LoadID)
        {
            KstCmsBase.Collection.WebMenuCollection WebMenu = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(LoadID), "MenuID");
            if (WebMenu.Count > 0)
            {
                throw new Exception("对不起，该站点已设置下属拦目，不能直接删除！");
            }
            Access db = new Access();
            db.DataDelete("WebTEMP", "SiteID", Convert.ToInt32(LoadID));
            db.DataDelete("LyINFO", "SiteID", Convert.ToInt32(LoadID));
            db.DataDelete("FLink", "SiteID", Convert.ToInt32(LoadID));

            int r = db.DataDelete("WebSite", "SiteID", Convert.ToInt32(LoadID));
            db.Dispose();
            return r;
        }

    }
}
