﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection.Wz;
using KstCmsBase.Entities.Wz;

namespace KstCmsBase.DAL.Wz
{
    public class Wz
    {
        private static void GetField(DataRow Row, string FieldName, ref Wz_Ent WZ)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "SiteID":
                   WZ.SiteID=Convert.ToInt32(FieldValue);
                   break;
                case "MenuID":
                   WZ.MenuID = Convert.ToInt32(FieldValue);
                   break;
                case "WzID":
                   WZ.WzID = Convert.ToInt32(FieldValue);
                   break;
                case "LbID":
                   WZ.LbID = Convert.ToInt32(FieldValue);
                   break;
                case "WzTitle":
                   WZ.WzTitle = FieldValue;
                    break;
                case "WzPic":
                    WZ.WzPic = FieldValue;
                    break;
                case "WzPic1":
                    WZ.WzPic1 = FieldValue;
                    break;
                case "WzDoc":
                    WZ.WzDoc = FieldValue;
                    break;
                case "WzContent":
                    WZ.WzContent = FieldValue;
                    break;
                case "IsNew":
                    WZ.IsNew = Convert.ToInt32(FieldValue);
                    break;
                case "IsTj":
                    WZ.IsTj = Convert.ToInt32(FieldValue);
                    break;
                case "IsHot":
                    WZ.IsHot = Convert.ToInt32(FieldValue);
                    break;
                case "SortNo":
                    WZ.SortNo = Convert.ToInt32(FieldValue);
                    break;
                case "uTime":
                    WZ.uTime = Convert.ToDateTime(FieldValue);
                    break;
                case "MateKey":
                    WZ.MateKey = FieldValue;
                    break;
                case "MateDesc":
                    WZ.MateDesc = FieldValue;
                    break;
                case "FileName":
                    WZ.FileName = FieldValue;
                    break;
                case "TempID":
                    WZ.TempID = Convert.ToInt32(FieldValue);
                    break;
            }
        }
        public static WzCollection Get_WzList(int SiteId,int MenuId,int LbId,bool Haspic,params string[] Fields)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder();
            sqlsb.Append(string.Format("from WzList where SiteID={0}", SiteId.ToString()));
            if (MenuId != 0)
                sqlsb.Append(string.Format(" and MenuID={0}", MenuId.ToString()));
            if (LbId != 0)
                sqlsb.Append(string.Format(" and LbID={0}", LbId.ToString()));
            if(Haspic)
                sqlsb.Append(" and WzPic<>''");
            sqlsb.Append(" order by SortNo desc,utime desc");
            string sql = db.Get_DbSQL(sqlsb.ToString(), Fields);
            WzCollection Items = new WzCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Wz_Ent item = new Wz_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }
        public static WzCollection Get_WzList(int SiteId, int MenuId, int LbId,int Attrib, bool Haspic, params string[] Fields)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder();
            sqlsb.Append(string.Format("from WzList where SiteID={0}", SiteId.ToString()));
            if (MenuId != 0)
                sqlsb.Append(string.Format(" and MenuID={0}", MenuId.ToString()));
            if (LbId != 0)
                sqlsb.Append(string.Format(" and LbID={0}", LbId.ToString()));
            if (Haspic)
                sqlsb.Append(" and WzPic<>''");
            switch (Attrib)
            {
                case 1:
                    sqlsb.Append(" and IsNew=1");
                    break;
                case 2:
                    sqlsb.Append(" and IsTj=1");
                    break;
                case 3:
                    sqlsb.Append(" and IsHot=1");
                    break;
            }
            sqlsb.Append(" order by SortNo desc,utime desc");
            string sql = db.Get_DbSQL(sqlsb.ToString(), Fields);
            WzCollection Items = new WzCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Wz_Ent item = new Wz_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }
        public static WzCollection Get_WzList(string Keyword,int SiteId, params string[] Fields)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder();
            sqlsb.Append(string.Format("from WzList where SiteID={0}", SiteId.ToString()));
            if (!string.IsNullOrEmpty(Keyword) && Keyword != "")
                sqlsb.Append(string.Format(" and WzTitle like '%{0}%' or WzDoc like '%{1}%'", Keyword, Keyword));
            sqlsb.Append(" order by SortNo desc,utime desc");
            string sql = db.Get_DbSQL(sqlsb.ToString(), Fields);
            WzCollection Items = new WzCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Wz_Ent item = new Wz_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }
        public static WzCollection Get_WzList(int SiteId, int MenuId, int attrib, bool Haspic, int WzCount, params string[] Fields)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder();
            sqlsb.Append(string.Format("from WzList where SiteID={0}", SiteId.ToString()));
            if (MenuId != 0)
                sqlsb.Append(string.Format(" and MenuID={0}", MenuId.ToString()));
            switch (attrib)
            {
                case 1:
                    sqlsb.Append(" and IsNew=1");
                    break;
                case 2:
                    sqlsb.Append(" and IsTj=1");
                    break;
                case 3:
                    sqlsb.Append(" and IsHot=1");
                    break;
            }
            if (Haspic)
                sqlsb.Append(" and WzPic<>''");
            sqlsb.Append(" order by SortNo desc,utime desc");
            string sql = db.Get_DbSQL(sqlsb.ToString(), WzCount, Fields);
            WzCollection Items = new WzCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Wz_Ent item = new Wz_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }
        public static WzCollection Get_WzList(int lbid, int attrib, bool Haspic, int WzCount, params string[] Fields)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder();
            sqlsb.Append(string.Format("from WzList where LbID={0}", lbid.ToString()));
            switch (attrib)
            {
                case 1:
                    sqlsb.Append(" and IsNew=1");
                    break;
                case 2:
                    sqlsb.Append(" and IsTj=1");
                    break;
                case 3:
                    sqlsb.Append(" and IsHot=1");
                    break;
            }
            if (Haspic)
                sqlsb.Append(" and WzPic<>''");
            sqlsb.Append(" order by SortNo desc,utime desc");
            string sql = db.Get_DbSQL(sqlsb.ToString(), WzCount, Fields);
            WzCollection Items = new WzCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Wz_Ent item = new Wz_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }

        public static Wz_Ent Get_WzInfo(int WzID, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WzList where WzID={0}", WzID.ToString()), Fields);
            Wz_Ent item = new Wz_Ent();
            DataSet dsData = db.ExecuteDataSet(sql);
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }

        public static int Wz_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "WzList", Fields);
            db.Dispose();
            return r;
        }
        public static int Wz_Update(int WzId, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("WzList", "WzID", WzId, Data, Fields);
            db.Dispose();
            return r;
        }
        public static int Wz_Delete(int WzId)
        {
            Access db = new Access();
            int r = db.DataDelete("WzList", "WzID", WzId);
            db.Dispose();
            return r;
        }

    }
}
