﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection.Wz;
using KstCmsBase.Entities.Wz;

namespace KstCmsBase.DAL.Wz
{
    public class WzLB
    {
        private static void GetField(DataRow Row, string FieldName, ref WzLB_Ent WzLB)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "LbID":
                    WzLB.LbID = Convert.ToInt32(FieldValue);
                    break;
                case "SiteID":
                    WzLB.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "MenuID":
                    WzLB.MenuID = Convert.ToInt32(FieldValue);
                    break;
                case "LbName":
                    WzLB.LbName = FieldValue;
                    break;
                case "SortNo":
                    WzLB.SortNo = Convert.ToInt32(FieldValue);
                    break;
                case "MateKey":
                    WzLB.MateKey = FieldValue;
                    break;
                case "MateDesc":
                    WzLB.MateDesc = FieldValue;
                    break;
                case "FileName":
                    WzLB.FileName = FieldValue;
                    break;
                case "TempID":
                    WzLB.TempID = Convert.ToInt32(FieldValue);
                    break;
            }
        }
        public static WzLBCollection Get_WzLbCollection(int SiteId,int MenuId,params string[] Fields)
        {
            Access db = new Access();
            StringBuilder sqlsb = new StringBuilder();
            sqlsb.Append(string.Format("from WzLB where SiteID={0}", SiteId.ToString()));
            if (MenuId != 0)
                sqlsb.Append(string.Format(" and MenuID={0}", MenuId.ToString()));
            sqlsb.Append(" order by SortNo asc");
            string sql = db.Get_DbSQL(sqlsb.ToString(), Fields);
            WzLBCollection Items = new WzLBCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WzLB_Ent item = new WzLB_Ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }
        public static WzLB_Ent Get_WzlbInfo(int lbid,params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WzLB where LbID={0}", lbid.ToString()), Fields);
            WzLB_Ent item = new WzLB_Ent();
            DataSet dsData = db.ExecuteDataSet(sql);
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }
        public static int Wzlb_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "WzLB", Fields);
            db.Dispose();
            return r;
        }
        public static int Wzlb_Update(int lbid, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("WzLB", "LbID", lbid, Data, Fields);
            db.Dispose();
            return r;
        }
        public static int Wzlb_Delete(int lbid)
        {
            Access db = new Access();
            int WzCount = Convert.ToInt32(db.getFieldValue(string.Format("select count(LbID) as id from WzList where LbID={0}", lbid.ToString())));
            if (WzCount > 0)
            {
                db.Dispose();
                throw new Exception("操作错误，此类下存在着相关文章，不能直接删除！");
            }
            int r = db.DataDelete("WzLB", "LbID", lbid);
            db.Dispose();
            return r;
        }


    }
}
