﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCmsBase.WebPage
{
    public class ValidationPage:ValiPage
    {
        protected bool isAdmin
        {
            get
            {
                bool Result = KstCmsBase.DAL.Users.Get_UserInfo(User.Identity.Name).isAdmin == 1;
                return Result;
            }
        }
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);
            Access();
           
        }

        /// <summary>
        /// 验证用户操作当前模块的权限
        /// </summary>
        /// <returns></returns>
        private void Access()
        {
            KstCmsBase.Entities.UsersEntity TTUser = KstCmsBase.DAL.Users.Get_UserInfo(User.Identity.Name);
            if (TTUser.isAdmin == 1)
            {
                return;
            }
            String ModuleUrl = Request.Url.PathAndQuery.Split('?')[0].ToLower();
            ModuleUrl = ModuleUrl.Remove(ModuleUrl.LastIndexOf('/'), ModuleUrl.Length - ModuleUrl.LastIndexOf('/'));
            ModuleUrl = ModuleUrl.Replace("/kstcms_manager/", "");
           // Response.Write(ModuleUrl);
          
            
            StringBuilder SqlSB = new StringBuilder();
            SqlSB.Append("select MENU_ID from(select MENU_ID,MENU_CODE from SUB_MENU union");
            SqlSB.Append(" select MENU_ID,MENU_URL as MENU_CODE from SYS_MENU) as A where A.MENU_CODE='{0}'");
            KstCmsBase.DAL.Access db = new DAL.Access();
            string MId = db.getFieldValue(string.Format(SqlSB.ToString(), ModuleUrl));
            db.Dispose();
            if (string.IsNullOrEmpty(MId))
            {
                throw new Exception("权限验证失败，请与管理员联系！");
            }
            //  String uRid = KOffice.Dal.Users.GetUserInfo(User.Identity.Name, "ROLE_ID").ROLE_ID_LIST;
            if (!KstCmsBase.DAL.SysMenu.isShowMenu(User.Identity.Name, MId))
            {
                throw new Exception("对不起！您没有权限操作此模块！");
            }
        }

    }
}
