﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace KstWEB
{
    public class SiteWeb:BaseWeb
    {
       
        public static void CreateIndexPage(int SiteId)
        { 
            KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId);
            string TempHtml = GetTemplates(WebSite.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG SystemTAG = new TagAnaly.SysTAG(WebSite.SiteID, 0, 0, string.Empty, 0, 0, 0);   ///创建系统标签实例
                    string html = SystemTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            string FilePath = SysRootUrl + "/" + WebSite.SiteVer + "/index" + HtmlExt;
            if (WebSite.DefaultSite == 1)
                FilePath = SysRootUrl + "/index" + HtmlExt;
            FilePath=System.Web.HttpContext.Current.Server.MapPath(FilePath);
            KstCmsBase.Common.Fucs.DeleteFile(FilePath);//删除旧文件
            System.IO.File.AppendAllText(FilePath, TempHtml);
            
        }

        public static void CreateMenuIndex(int SiteId, int MenuId)
        {
            string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.WebMenu_ent WebMenu =KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(MenuId,"GoUrl","TempID");
            string TempHtml = GetTemplates(WebMenu.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, string.Empty, 0, 0, 0);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            string File = FilePath + WebMenu.GoUrl + HtmlExt;
            File = System.Web.HttpContext.Current.Server.MapPath(File);
            KstCmsBase.Common.Fucs.DeleteFile(File);//删除旧文件
            System.IO.File.AppendAllText(File, TempHtml);
        }

        public static void CreateuPage(int SiteId, int MenuId, int LmId)
        {
            string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.WebLm_ent lm = KstCmsBase.DAL.WebLM.Get_WebLMInfo(LmId, "uPageFile", "TempID");
            string TempHtml = GetTemplates(lm.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, LmId, string.Empty, 0, 0, 0);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            string File = FilePath + lm.uPageFile + HtmlExt;
            File = System.Web.HttpContext.Current.Server.MapPath(File);
            KstCmsBase.Common.Fucs.DeleteFile(File);//删除旧文件
            System.IO.File.AppendAllText(File, TempHtml);

        }
        public static void CreateProListOnPage(int SiteId, int MenuId, int lbid,string classid)
        {
            string Url = GetSiteMenuUrl(SiteId, MenuId);  //导航Url
            string[] FileHtmls = null;  //用来暂返回的WEB页
            string ListTAG = string.Empty;
            KstCmsBase.Collection.Product.ProductCollection ProItems = null;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();

            KstCmsBase.Entities.Product.ProLB_Ent ProLB = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(lbid, "TempID", "Alias");
            string FilePath = Url + ProLB.Alias + "_";
            string TempHtml = GetTemplates(ProLB.TempID.ToString());

            foreach (KstCmsBase.Entities.Tag.VarTAG_ent Tag in VarTAG_Items)
            {
                if (TempHtml.ToLower().IndexOf(Tag.VarTAG.ToLower()) != -1)
                {
                    KstWEB.TagAnaly.SysTAG SysTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, classid, 0, 0, 0);
                   // MyTAG.PageSize = ProPageSize;
                    string html = SysTAG.Handling_VarLable(Tag.TagContent);
                    string ListHtml = SysTAG.ListHtmlCode;
                    //解析签标内容后,返回HTML内容,如果VarTAG.TagContent中含有<!-kst:prolistonpage，处理后html会含有#page#,含有多个#page#列表就有多页
                    if (ListHtml.IndexOf("#page#") != -1)
                    {
                        ProItems = (KstCmsBase.Collection.Product.ProductCollection)SysTAG.DataCollection; //同步系统标签 处理产品分类列表标签时的产品数据集
                        ListTAG = Tag.VarTAG;
                        FileHtmls = ListHtml.Split(new string[] { "#page#" }, StringSplitOptions.RemoveEmptyEntries);
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                    }
                    else
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                }
            }
            if (ProItems != null)
                Handling_ShowPage(SiteId, FileHtmls, FilePath, TempHtml);
            else
            {
                string FileUrl = System.Web.HttpContext.Current.Server.MapPath(FilePath + "0" + HtmlExt);
                KstCmsBase.Common.Fucs.DeleteFile(FileUrl);//删除旧文件
                System.IO.File.AppendAllText(FileUrl, TempHtml);
            }


        }

        public static void CreateWzListOnPage(int SiteId, int MenuId, int lbid)
        {
            string Url = GetSiteMenuUrl(SiteId, MenuId);  //导航Url
            string[] FileHtmls = null;  //用来暂返回的WEB页
            string ListTAG = string.Empty;
            KstCmsBase.Collection.Wz.WzCollection WzItems = null;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            KstCmsBase.Entities.Wz.WzLB_Ent WzLB = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(lbid, "FileName", "TempID");
            string FilePath = Url + WzLB.FileName + "_";
            string TempHtml = GetTemplates(WzLB.TempID.ToString());

            foreach (KstCmsBase.Entities.Tag.VarTAG_ent Tag in VarTAG_Items)
            {
                if (TempHtml.ToLower().IndexOf(Tag.VarTAG.ToLower()) != -1)
                {
                    KstWEB.TagAnaly.SysTAG SysTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, string.Empty, 0, lbid, 0);
                    // MyTAG.PageSize = ProPageSize;
                    string html = SysTAG.Handling_VarLable(Tag.TagContent);
                    string ListHtml = SysTAG.ListHtmlCode;
                    //解析签标内容后,返回HTML内容,如果VarTAG.TagContent中含有<!-kst:prolistonpage，处理后html会含有#page#,含有多个#page#列表就有多页
                    if (ListHtml.IndexOf("#page#") != -1)
                    {
                        WzItems = (KstCmsBase.Collection.Wz.WzCollection)SysTAG.DataCollection; //同步系统标签 处理产品分类列表标签时的产品数据集
                        ListTAG = Tag.VarTAG;
                        FileHtmls = ListHtml.Split(new string[] { "#page#" }, StringSplitOptions.RemoveEmptyEntries);
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                    }
                    else
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                }
            }
            if (WzItems != null)
                Handling_ShowPage(SiteId, FileHtmls, FilePath, TempHtml);
            else
            {
                string FileUrl = System.Web.HttpContext.Current.Server.MapPath(FilePath + "0" + HtmlExt);
                KstCmsBase.Common.Fucs.DeleteFile(FileUrl);//删除旧文件
                System.IO.File.AppendAllText(FileUrl, TempHtml);
            }
        }

        private static void Handling_ShowPage(int SiteId, string[] FileHtmls, string FilePath, string TempHtml)
        {
            string First = "<img src=\"" + SysRootUrl + "/Styles/first.gif\" align=\"absmiddle\" border=\"0\" />";
            string First1 = "<img src=\"" + SysRootUrl + "/Styles/first1.gif\" align=\"absmiddle\" border=\"0\" />";
            string Prev = "<img src=\"" + SysRootUrl + "/Styles/prev.gif\" align=\"absmiddle\" border=\"0\" />";
            string Prev1 = "<img src=\"" + SysRootUrl + "/Styles/prev1.gif\" align=\"absmiddle\" border=\"0\" />";
            string Next = "<img src=\"" + SysRootUrl + "/Styles/next.gif\" align=\"absmiddle\" border=\"0\" />";
            string Next1 = "<img src=\"" + SysRootUrl + "/Styles/next1.gif\" align=\"absmiddle\" border=\"0\" />";
            string Last = "<img src=\"" + SysRootUrl + "/Styles/last.gif\" align=\"absmiddle\" border=\"0\" />";
            string Last1 = "<img src=\"" + SysRootUrl + "/Styles/last1.gif\" align=\"absmiddle\" border=\"0\" />";

           
            ///创建分页文件
            for (int i = 0; i < FileHtmls.Length; i++)
            {
                string FileHtmlCode = TempHtml.Replace("#showlist#", FileHtmls[i]);
                string ShowPageHtml = string.Empty;
                string ShowPageNo = string.Empty;
                string UrlFile = FilePath + i + HtmlExt;
                int PageNo = 1;  ///页码
                if (FileHtmlCode.IndexOf("#showpage#") != -1)
                {
                    int n = 1;
                    while (PageNo <= FileHtmls.Length)
                    {
                        if (PageNo - 1 == i) //当前页
                            ShowPageNo += "[<span>" + PageNo + "</span>]";
                        else
                            ShowPageNo += "<a href=\"" + FilePath + (PageNo - 1) + HtmlExt + "\">[" + PageNo + "]</a>";
                        PageNo++;
                        n++;
                        if (n >= 10)
                            break;
                    }
                }
                //到第一页
                if (i != 0)
                    ShowPageHtml = "<a href=\"" + FilePath + 0 + HtmlExt + "\">" + First + "</a>";
                else
                    ShowPageHtml = First1;
                //到上一页
                if (i > 0)
                    ShowPageHtml += "<a href=\"" + FilePath + (i - 1) + HtmlExt + "\">" + Prev + "</a>";
                else
                    ShowPageHtml += Prev1;

                ShowPageHtml += ShowPageNo;
                if (i < (FileHtmls.Length-1))
                {
                    //到下一页
                    ShowPageHtml += "<a href=\"" + FilePath + (i + 1) + HtmlExt + "\">" + Next + "</a>";
                    //到最后一页
                    ShowPageHtml += "<a href=\"" + FilePath + (FileHtmls.Length - 1) + HtmlExt + "\">" + Last + "</a>";
                }
                else
                {
                    ShowPageHtml += Next1;
                    ShowPageHtml += Last1;
                }
                FileHtmlCode = FileHtmlCode.Replace("#showpage#", ShowPageHtml);
                UrlFile = System.Web.HttpContext.Current.Server.MapPath(UrlFile);
                KstCmsBase.Common.Fucs.DeleteFile(UrlFile);//删除旧文件
                System.IO.File.AppendAllText(UrlFile, FileHtmlCode);
            }
        }


        public static void CreateProduct(int SiteId, int MenuId, int lbid, string classid,int ProId)
        {
            string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.Product.Product_Ent Pro = KstCmsBase.DAL.Product.Product.GetProductInfo(ProId, "FileName", "TempID");
            string TempHtml = GetTemplates(Pro.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, classid, ProId, 0, 0);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            string File = FilePath + Pro.FileName + HtmlExt;
            File = System.Web.HttpContext.Current.Server.MapPath(File);
            KstCmsBase.Common.Fucs.DeleteFile(File);//删除旧文件
            System.IO.File.AppendAllText(File, TempHtml);
        }

        public static void CreateWz(int SiteId, int MenuId, int lbid, int Wzid)
        {
            string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.Wz.Wz_Ent WZent = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(Wzid, "FileName", "TempID");
            string TempHtml = GetTemplates(WZent.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, string.Empty, 0, lbid, Wzid);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            string File = FilePath + WZent.FileName + HtmlExt;
            File = System.Web.HttpContext.Current.Server.MapPath(File);
            KstCmsBase.Common.Fucs.DeleteFile(File);//删除旧文件
            System.IO.File.AppendAllText(File, TempHtml);
        }

        public static void CreateSiteMap(int SiteId)
        {
            string TempHtml = KstCmsBase.DAL.Templates.GetDefaultTemplate(KstCmsBase.DAL.Templates.TempType.SiteMap, SiteId).TempContent;
            KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId);
            string FilePath = SysRootUrl + "/" + WebSite.SiteVer + "/SiteMap" + HtmlExt;
            if (WebSite.DefaultSite == 1)
                FilePath = SysRootUrl + "/SiteMap" + HtmlExt;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(WebSite.SiteID, 0, 0, string.Empty, 0, 0, 0);   ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            FilePath = System.Web.HttpContext.Current.Server.MapPath(FilePath);
            KstCmsBase.Common.Fucs.DeleteFile(FilePath);//删除旧文件
            System.IO.File.AppendAllText(FilePath, TempHtml);
        }

        public static void CreateLinkPage(int SiteId)
        {
            string TempHtml = KstCmsBase.DAL.Templates.GetDefaultTemplate(KstCmsBase.DAL.Templates.TempType.Link, SiteId).TempContent;
            KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId);
            string FilePath = SysRootUrl + "/" + WebSite.SiteVer + "/Link" + HtmlExt;
            if (WebSite.DefaultSite == 1)
                FilePath = SysRootUrl + "/Link" + HtmlExt;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(WebSite.SiteID, 0, 0, string.Empty, 0, 0, 0);   ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            FilePath = System.Web.HttpContext.Current.Server.MapPath(FilePath);
            KstCmsBase.Common.Fucs.DeleteFile(FilePath);//删除旧文件
            System.IO.File.AppendAllText(FilePath, TempHtml);
        }

        public static void Create_SiteMapXML(string dns)
        {
            string XmlFile = SysRootUrl + "/sitemap.xml";
            string Url = SysRootUrl + "/";
            string DnsUrl = "http://" + dns;
            StringBuilder Xmlsb =new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>\r\n");
            Xmlsb.Append("<urlset xmlns='http://www.google.com/schemas/sitemap/0.84'>\r\n");
            string[]IndexFiles=System.IO.Directory.GetFiles(System.Web.HttpContext.Current.Server.MapPath(Url), "*" + HtmlExt);
                foreach (string file in IndexFiles)
                {
                    DateTime dt = System.IO.File.GetLastWriteTime(file);
                    string linkfile = file.Substring(file.LastIndexOf("\\") + 1);
                    Xmlsb.Append("<url><loc>" + DnsUrl + Url + linkfile + "</loc><lastmod>" + dt.ToString("yyyy-MM-dd") + "</lastmod><changefreq>daily</changefreq><priority>1.0</priority></url>\r\n");
                }

            KstCmsBase.Collection.WebSite_Collection SiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteVer");

            StringBuilder SiteXml = new StringBuilder();
            StringBuilder MenuXml = new StringBuilder();
            foreach (KstCmsBase.Entities.WebSite_ent mySite in SiteItems)
            {
                string SiteUrl = Url + mySite.SiteVer + "/";
                string[] SiteFiles = System.IO.Directory.GetFiles(System.Web.HttpContext.Current.Server.MapPath(SiteUrl), "*" + HtmlExt);
                foreach (string file in SiteFiles)
                {
                    DateTime dt = System.IO.File.GetLastWriteTime(file);
                    string linkfile = file.Substring(file.LastIndexOf("\\") + 1);
                    SiteXml.Append("<url><loc>" + DnsUrl + SiteUrl + linkfile + "</loc><lastmod>" + dt.ToString("yyyy-MM-dd") + "</lastmod><changefreq>daily</changefreq><priority>1.0</priority></url>\r\n");  
                }
                KstCmsBase.Collection.WebMenuCollection WebMenus = KstCmsBase.DAL.WebMenu.Get_MenuList(mySite.SiteID, "MenuDiy");
                foreach (KstCmsBase.Entities.WebMenu_ent Menu in WebMenus)
                {
                    string MenuUrl = SiteUrl + Menu.MenuDiy + "/";
                    string[] MenuFiles = System.IO.Directory.GetFiles(System.Web.HttpContext.Current.Server.MapPath(MenuUrl), "*" + HtmlExt);
                    foreach (string file in MenuFiles)
                    {
                        DateTime dt = System.IO.File.GetLastWriteTime(file);
                        string linkfile = file.Substring(file.LastIndexOf("\\") + 1);
                        MenuXml.Append("<url><loc>" + DnsUrl + MenuUrl + linkfile + "</loc><lastmod>" + dt.ToString("yyyy-MM-dd") + "</lastmod><changefreq>daily</changefreq><priority>1.0</priority></url>\r\n");
                    }
                }
            }
            Xmlsb.Append(SiteXml.ToString());
            Xmlsb.Append(MenuXml.ToString());
            Xmlsb.Append("</urlset>");
            KstCmsBase.Common.Fucs.DeleteFile(System.Web.HttpContext.Current.Server.MapPath(XmlFile));
            System.IO.File.AppendAllText(System.Web.HttpContext.Current.Server.MapPath(XmlFile),Xmlsb.ToString(),System.Text.Encoding.UTF8);
        }

        private static string GetTemplates(string TempId)
        {

            string Result = string.Empty;
            if (System.Web.HttpContext.Current.Cache.Get("TempId"+TempId) != null)
                Result = System.Web.HttpContext.Current.Cache.Get("TempId" + TempId).ToString();
            else
            {
                Result = KstCmsBase.DAL.Templates.GetTemplate(TempId).TempContent;
                if(!string.IsNullOrEmpty(Result))
                    System.Web.HttpContext.Current.Cache.Add("TempId" + TempId, Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }
            return Result;
        }



    }
}
