﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstWEB.TagAnaly
{
    public class ContentTAG:BaseWeb
    {
        public string HtmlCode { get { return _HtmlCode; } }
        private int _SiteId;
        private int _MenuId;
        private string _HtmlCode = string.Empty;
        private string _ContentTAG = string.Empty;//内容代码
        private string _utimeFormat = string.Empty;
        public ContentTAG(int SiteId, int MenuId, int TagId)
        {
            
            _SiteId = SiteId; _MenuId = MenuId;
            _ContentTAG = KstCmsBase.DAL.Tag.TagTEMP.Get_TagDESC(TagId).ContentTAG;
            _utimeFormat = Set_utimeFormat(KstCmsBase.DAL.Tag.TagTEMP.Get_TagDESC(TagId).uTimeFormat);
        }
        public void Handling_ProContent(int ProId,string lytitle,int FrmId)
        {
            KstCmsBase.Entities.Product.Product_Ent pro = KstCmsBase.DAL.Product.Product.GetProductInfo(ProId);
            _ContentTAG = _ContentTAG.Replace("<!-title-!>", pro.ProName);
            _ContentTAG = _ContentTAG.Replace("<!-prono-!>", pro.ProNo);
            _ContentTAG = _ContentTAG.Replace("<!-doc-!>", pro.ProDoc);
            _ContentTAG = _ContentTAG.Replace("<!-spic-!>", "<a href=\"javascript:ShowLightBox('"+pro.Pic3+"');\"><img src=\"" + pro.Pic1 + "\" id=\"spic\" border=\"0\"  style=\"cursor:pointer\" /></a>");
            _ContentTAG = _ContentTAG.Replace("<!-mpic-!>", "<a href=\"javascript:ShowLightBox('" + pro.Pic3 + "');\"><img src=\"" + pro.Pic2 + "\" id=\"mpic\" border=\"0\" style=\"cursor:pointer\" /></a>");
            _ContentTAG = _ContentTAG.Replace("<!-bpic-!>", "<a href=\"javascript:ShowLightBox('" + pro.Pic3 + "');\"><img src=\"" + pro.Pic3 + "\" id=\"bpic\" border=\"0\" style=\"cursor:pointer\" /></a>");
            _ContentTAG = _ContentTAG.Replace("<!-utime-!>", string.Format(_utimeFormat, pro.uTime));
            string Contentstr = string.Empty;
            foreach (KstCmsBase.Entities.Product.DescField_Ent FiEnt in pro.DescFieldItems)
            {
                Contentstr += "<li>" + FiEnt.FieldName + "<li>";
                Contentstr += "<ul><li>" + FiEnt.FieldValue + "</li></ul>";
            }
            _ContentTAG = _ContentTAG.Replace("<!-content-!>", Contentstr);
            _ContentTAG = _ContentTAG.Replace("<!-extfield-!>", Get_ExtField(ProId.ToString()));
            _ContentTAG = _ContentTAG.Replace("<!-extdesc-!>", Get_ExtDescField(ProId.ToString(), pro.ProName, lytitle, FrmId));
            _ContentTAG = _ContentTAG.Replace("<!-piclist-!>", Get_PicList(ProId.ToString(), pro.Pic2));
            _ContentTAG = _ContentTAG.Replace("<!-downlist-!>", Get_FileList(ProId.ToString()));
            _HtmlCode = _ContentTAG;
        }


        public void Handling_WzContent(int Wzid)
        {
            KstCmsBase.Entities.Wz.Wz_Ent WZ = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(Wzid);
            _ContentTAG = _ContentTAG.Replace("<!-title-!>", WZ.WzTitle);
            _ContentTAG = _ContentTAG.Replace("<!-prono-!>", "");
            _ContentTAG = _ContentTAG.Replace("<!-doc-!>", WZ.WzDoc);
            _ContentTAG = _ContentTAG.Replace("<!-spic-!>", "<a href=\"javascript:ShowLightBox('" + WZ.WzPic1 + "');\"><img src=\"" + WZ.WzPic + "\" id=\"spic\" border=\"0\"  style=\"cursor:pointer\" /></a>");
            _ContentTAG = _ContentTAG.Replace("<!-mpic-!>", "");
            _ContentTAG = _ContentTAG.Replace("<!-bpic-!>", "");
            _ContentTAG = _ContentTAG.Replace("<!-utime-!>", string.Format(_utimeFormat, WZ.uTime));
            _ContentTAG = _ContentTAG.Replace("<!-content-!>", WZ.WzContent);
            _ContentTAG = _ContentTAG.Replace("<!-extfield-!>","");
            _ContentTAG = _ContentTAG.Replace("<!-extdesc-!>", "");
            _ContentTAG = _ContentTAG.Replace("<!-piclist-!>", "");
            _ContentTAG = _ContentTAG.Replace("<!-downlist-!>", "");
            _HtmlCode = _ContentTAG;
        }

        private string Get_FileList(string ProId)
        {
            string Result = string.Empty;
            KstCmsBase.Collection.Product.ProductFileCollection FileItems = KstCmsBase.DAL.Product.Product.GetProductFiles(ProId);
            foreach (KstCmsBase.Entities.Product.ProductFile_Ent file in FileItems)
            {
                Result += "<a href=\"" + file.FilePath + "\">" + file.FileName + "</a>&nbsp;";
            }
            return Result;
        }
        private string Get_PicList(string ProId,string sPic)
        {
            string Result = string.Empty;
            KstCmsBase.Collection.Product.ProductPicCollection PicItems = KstCmsBase.DAL.Product.Product.GetProductPics(ProId);
            string html = string.Empty;
            foreach (KstCmsBase.Entities.Product.ProductPic_Ent pic in PicItems)
            {
                html += "<td><a href=\"javascript:ShowLightBox('" + pic.Pic3 + "');\"><img src=\"" + pic.Pic1 + "\" width=\"50\" onmouseover=\"selectpic('" + pic.Pic2 + "');\" onmouseout=\"outpic('" + sPic + "');\" border=\"0\" /></a></td>";
            }
            html = "<table width=\"100\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\"><tr>" + html + "</tr></table>";
            Result = html;
            return Result;
        }

        private string Get_ExtField(string ProId)
        {
            string Result = string.Empty;
            KstCmsBase.Collection.Product.PostFieldCollection FieldItems = KstCmsBase.DAL.Product.Product.GetPostFieldList(ProId);
            string html = string.Empty;
            foreach (KstCmsBase.Entities.Product.PostField_Ent Field in FieldItems)
            {
                html += "<tr>";
                html += "<td>" + Field.FieldName + ":</td><td>" + Field.FieldValue + "</td>";
                html += "</tr>";
            }
            if (!string.IsNullOrEmpty(html))
                Result = "<table>" + html + "</table>";
            return Result;
        }

        private string Get_ExtDescField(string ProId,string ProName,string lytitle,int FrmId)
        {
            string Result = string.Empty;
            KstCmsBase.Collection.Product.DescFieldCollection DescFields = KstCmsBase.DAL.Product.Product.GetDescFieldList(ProId);
            string HeadHtml = string.Empty;
            string DocHtml = string.Empty;
            int i = 0;
            int Count = DescFields.Count;
            if (lytitle.ToLower() != "null")
                Count++;
            foreach (KstCmsBase.Entities.Product.DescField_Ent Field in DescFields)
            {
                if (i != 0)
                {
                    HeadHtml += "<td id=\"DescHead" + i + "\" onclick=\"Opendesc('desc" + i + "',this," + Count + ");\" style=\"cursor:pointer\" nowrap>" + Field.FieldName + "</td>";
                    DocHtml += "<tbody id=\"desc" + i + "\" style=\"display:none\"><tr><td>" + Field.FieldValue + "</td></tr></tbody>";
                }
                else
                {
                    HeadHtml += "<td id=\"DescHead" + i + "\" onclick=\"Opendesc('desc" + i + "',this," + Count + ");\" style=\"cursor:pointer\" class=\"onclicktd\" nowrap>" + Field.FieldName + "</td>";
                    DocHtml += "<tbody id=\"desc" + i + "\" ><tr><td>" + Field.FieldValue + "</td></tr></tbody>";
                }

                i++;
            }
            if (lytitle.ToLower() != "null")
            {
                HeadHtml += "<td nowrap id=\"DescHead" + i + "\" onclick=\"Opendesc('desc" + i + "',this," + Count + ");\" style=\"cursor:pointer\">" + lytitle + "</td>";
                DocHtml += "<tbody id=\"desc" + i + "\" style=\"display:none\"><tr><td>" + GetLyFrm(FrmId).Replace("#lytitle#", ProName) + "</td></tr></tbody>";
            }
            HeadHtml = "<div class=\"DescItemName\"><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\"><tr>" + HeadHtml + "</tr></table></div>";
            HeadHtml += "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">" + DocHtml + "</table>";
            Result = HeadHtml;
            return Result;
        }



        private string Set_utimeFormat(int Code)
        {
            string Result = string.Empty;
            switch (Code)
            {
                case 0:
                    Result = string.Empty;
                    break;
                case 1:
                    Result = "{0:yyyy-MM-dd}"; ///2011-01-01
                    break;
                case 2:
                    Result = "{0:D}";///2011年1月1日
                    break;
                case 3:
                    Result = "{0:g}";
                    break;
                case 4:
                    Result = "{0:MM-dd}";
                    break;
                case 5:
                    Result = "{0:M}";
                    break;
            }
            return Result;
        }
    }
}
