﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstWEB.TagAnaly
{
    public class ListTAG:BaseWeb
    {
        
        public string HtmlCode { get { return _HtmlCode; } }
        public int Columns { get { return _Columns; } }
        private int _SiteId;
        private int _MenuId;
        private string _LinkUrl = string.Empty;
        private string _MenuName = string.Empty;

        private string _HtmlCode = string.Empty;  //最终返回的代码
        private string _ListTAG = string.Empty;   //列表代码，中含有变量标签
        private string _ContentTAG = string.Empty;//内容代码
        private int _TitleLen = 0;
        private int _DocLen = 0;
        private string _utimeFormat = string.Empty;
        private string _VarStr = string.Empty;    //<!-sloop-!>与<!-eloop-!>之间的HTML代码
        private string _VarList = string.Empty;   //Var变量，多个以"|"隔开
        string _loopStr = string.Empty;  
        private int _Columns = 0;
        private KstCmsBase.Entities.Tag.TagTEMP_ent TagTEMP= null;
        public ListTAG(int TagId,int SiteId,int MenuId)
        {
            _SiteId = SiteId;
            _MenuId = MenuId;
            _LinkUrl = GetSiteMenuUrl(_SiteId, _MenuId);
            _MenuName = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(_MenuId, "MenuName").MenuName;
            TagTEMP = KstCmsBase.DAL.Tag.TagTEMP.Get_TagTEMP(TagId);
            _ContentTAG = TagTEMP.ContentTAG;
            _ListTAG = TagTEMP.ListTAG;
            _TitleLen = TagTEMP.TitleLEN;
            _DocLen = TagTEMP.DocLEN;
            _utimeFormat = Set_utimeFormat(TagTEMP.UtimeFormat);
            int Stag = _ContentTAG.IndexOf("<!-sloop-!>") + "<!-sloop-!>".Length;
            int Etag = _ContentTAG.IndexOf("<!-eloop-!>");
            if (Stag == -1 || Etag == -1)
                throw new Exception("sloop或eloop列表标签设置错误!");
            _VarStr = _ContentTAG.Substring(Stag, Etag - Stag);  //<!-sloop-!>与<!-eloop-!>之间的HTML代码
            string VarStr = _VarStr;
            
            string Var = "<!-var";
            while (VarStr.IndexOf(Var) != -1)
            {
                _Columns++;  //累加VAR 列数量
                int s = _VarStr.IndexOf(Var) + Var.Length;
                int e = _VarStr.IndexOf("-!>");
                if(s==-1||e==-1)
                    throw new Exception("Var列表标签设置错误!");
                int i = Convert.ToInt32(_VarStr.Substring(s, e - s));
                VarStr = VarStr.Replace(Var + _Columns.ToString() + "-!>", "");
                _VarList += Var + _Columns.ToString() + "-!>|";   //将列表标签中的多个<!-var-!>用"|"连接在一起
            }
        }
/// <summary>
/// 栏目导航
/// </summary>
/// <param name="LmItems"></param>
/// <param name="_CurrentPageIndex"></param>
        public void Handling_TagTemp(System.Collections.ArrayList Items, ref int _CurrentRow,string TypeName=null)
        {
            _loopStr += _VarStr;
            System.Collections.ArrayList ListItems = null;
            string[] VarLists = _VarList.Split(new string[] { "|" }, StringSplitOptions.RemoveEmptyEntries);
            _Columns = VarLists.Length;
            if (_CurrentRow * _Columns < Items.Count)
            {
                ListItems = Items.GetRange(_Columns * (_CurrentRow - 1), _Columns);
            }
            else
            {
                int EndCount = Items.Count - ((_CurrentRow - 1) * _Columns);
                ListItems = Items.GetRange(_Columns * (_CurrentRow - 1), EndCount);
            }
            if(TypeName==null)
                 TypeName = Items.GetType().Name;
            for (int i = 0; i < ListItems.Count; i++)
            {
                switch (TypeName)
                {
                    case "WebLmCollection":
                         _loopStr = _loopStr.Replace(VarLists[i], Get_ListTAG((KstCmsBase.Entities.WebLm_ent)ListItems[i], _ListTAG)); ///替换VAR变量
                        break;
                    case "ProductCollection":
                        _loopStr = _loopStr.Replace(VarLists[i], Get_ListTAG((KstCmsBase.Entities.Product.Product_Ent)ListItems[i], _ListTAG)); ///替换VAR变量
                        break;
                    case "WzCollection":
                        _loopStr = _loopStr.Replace(VarLists[i], Get_ListTAG((KstCmsBase.Entities.Wz.Wz_Ent)ListItems[i], _ListTAG)); ///替换VAR变量
                        break;
                    case "LinkCollection":
                        _loopStr = _loopStr.Replace(VarLists[i], Get_ListTAG((KstCmsBase.Entities.Link.LinkEnt)ListItems[i], _ListTAG)); ///替换VAR变量
                        break;
                }
            }

            if (_CurrentRow * _Columns >= Items.Count)
            {
                _HtmlCode = _ContentTAG.Replace("<!-sloop-!>" + _VarStr + "<!-eloop-!>", _loopStr);
                _HtmlCode = HandlingContent(_HtmlCode);
                return;
            }
            else
            {
                _CurrentRow++;
                Handling_TagTemp(Items, ref _CurrentRow, TypeName);// 递归
            }
        }

        private string Get_ListTAG(KstCmsBase.Entities.BaseEntitics item, string ListTAG)
        {
            if (WebExeute != 1) _LinkUrl = SysRootUrl + "/aspx/";
            switch (item.GetType().Name)
            {
                case "WebLm_ent":
                    KstCmsBase.Entities.WebLm_ent Lm = (KstCmsBase.Entities.WebLm_ent)item;
                    if (WebExeute == 1)
                        ListTAG = ListTAG.Replace("<!-url-!>", _LinkUrl  + Lm.uPageFile + HtmlExt);
                    else
                        ListTAG = ListTAG.Replace("<!-url-!>", _LinkUrl + "uPage" + HtmlExt + "?SiteId=" + Lm.SiteID + "&MenuId=" + Lm.MenuID + "&LmId=" + Lm.LmID);
                    ListTAG = ListTAG.Replace("<!-title-!>", Lm.LmName).Replace("<!-id-!>", Lm.LmID.ToString());
                    break;
                case "Product_Ent":
                    KstCmsBase.Entities.Product.Product_Ent ProEnt = (KstCmsBase.Entities.Product.Product_Ent)item;
                    string LenProName = ProEnt.ProName;
                    if (_TitleLen != 0)
                        if (LenProName.Length > _TitleLen)
                            LenProName = LenProName.Substring(0, _TitleLen) + "...";
                    string LenProDoc = ProEnt.ProDoc;
                    if (_DocLen != 0)
                        if (LenProDoc.Length > _DocLen)
                            LenProDoc = LenProDoc.Substring(0, _DocLen) + "...";
                    ListTAG = ListTAG.Replace("<!-title-!>", ProEnt.ProName);
                    ListTAG = ListTAG.Replace("<!-title1-!>", LenProName);
                    ListTAG = ListTAG.Replace("<!-id-!>", ProEnt.ProID.ToString());
                    if (WebExeute == 1)
                        ListTAG = ListTAG.Replace("<!-url-!>", _LinkUrl + ProEnt.FileName + HtmlExt);
                    else
                    {
                        string classid = ProEnt.LbID.Substring(0, ProEnt.LbID.LastIndexOf(","));
                        ListTAG = ListTAG.Replace("<!-url-!>", _LinkUrl + "ShowPro" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + classid + "&ProId=" + ProEnt.ProID);
                    }
                    ListTAG = ListTAG.Replace("<!-utime-!>", string.Format(_utimeFormat, ProEnt.uTime));
                    ListTAG = ListTAG.Replace("<!-doc-!>", LenProDoc);
                    ListTAG = ListTAG.Replace("<!-prono-!>", ProEnt.ProNo);
                    ListTAG = ListTAG.Replace("<!-spic-!>", ProEnt.Pic1);
                    ListTAG = ListTAG.Replace("<!-mpic-!>", ProEnt.Pic2);
                    ListTAG = ListTAG.Replace("<!-bpic-!>", ProEnt.Pic3);
                    ListTAG = ListTAG.Replace("<!-extfield-!>", Get_ExtField(ProEnt.ProID.ToString()));
                    ListTAG = ListTAG.Replace("<!-extdesc-!>", "");
                    break;
                case "Wz_Ent":
                   
                    KstCmsBase.Entities.Wz.Wz_Ent wz = (KstCmsBase.Entities.Wz.Wz_Ent)item;
                    string LenWzTitle = wz.WzTitle;
                    if (_TitleLen != 0)
                        if (LenWzTitle.Length > _TitleLen)
                            LenWzTitle = LenWzTitle.Substring(0, _TitleLen) + "...";
                    string LenWzdoc = wz.WzDoc;
                    if (_DocLen != 0)
                        if (LenWzdoc.Length > _DocLen)
                            LenWzdoc = LenWzdoc.Substring(0, _DocLen) + "...";
                    ListTAG = ListTAG.Replace("<!-title-!>", wz.WzTitle);
                    ListTAG = ListTAG.Replace("<!-title1-!>", LenWzTitle);
                    ListTAG = ListTAG.Replace("<!-id-!>", wz.WzID.ToString());
                    if (WebExeute == 1)
                        ListTAG = ListTAG.Replace("<!-url-!>", _LinkUrl + wz.FileName + HtmlExt);
                    else
                        ListTAG = ListTAG.Replace("<!-url-!>", _LinkUrl + "ShowAct" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&Wzlbid=" + wz.LbID + "&WzId=" + wz.WzID.ToString());
                    ListTAG = ListTAG.Replace("<!-utime-!>", string.Format(_utimeFormat,wz.uTime));
                    ListTAG = ListTAG.Replace("<!-doc-!>", LenWzdoc);
                    ListTAG = ListTAG.Replace("<!-prono-!>", "");
                    ListTAG = ListTAG.Replace("<!-spic-!>", wz.WzPic);
                    ListTAG = ListTAG.Replace("<!-mpic-!>", wz.WzPic1);
                    ListTAG = ListTAG.Replace("<!-bpic-!>", "");
                    ListTAG = ListTAG.Replace("<!-extfield-!>", "");
                    ListTAG = ListTAG.Replace("<!-extdesc-!>", "");
                    break;
                case "LinkEnt":
                    KstCmsBase.Entities.Link.LinkEnt Link = (KstCmsBase.Entities.Link.LinkEnt)item;
                    ListTAG = ListTAG.Replace("<!-title-!>", Link.LinkName);
                    ListTAG = ListTAG.Replace("<!-title1-!>",Link.SiteName);
                    ListTAG = ListTAG.Replace("<!-id-!>", Link.LinkID.ToString());
                    ListTAG = ListTAG.Replace("<!-url-!>", Link.LinkUrl);
                    ListTAG = ListTAG.Replace("<!-spic-!>", Link.LogoUrl);
                    ListTAG = ListTAG.Replace("<!-classname-!>", "");
                    ListTAG = ListTAG.Replace("<!-classid-!>", "");
                    ListTAG = ListTAG.Replace("<!-classurl-!>", "");
                    ListTAG = ListTAG.Replace("<!-utime-!>", "");
                    ListTAG = ListTAG.Replace("<!-doc-!>", "");
                    ListTAG = ListTAG.Replace("<!-prono-!>", "");
                    ListTAG = ListTAG.Replace("<!-mpic-!>", "");
                    ListTAG = ListTAG.Replace("<!-bpic-!>", "");
                    ListTAG = ListTAG.Replace("<!-extfield-!>", "");
                    ListTAG = ListTAG.Replace("<!-extdesc-!>", "");
                    break;

            }

            return ListTAG;
        }
/// <summary>
/// 解析内容变量标签
/// </summary>
/// <param name="Html"></param>
/// <returns></returns>
        private string HandlingContent(string Html)
        {
            if (WebExeute != 1) _LinkUrl = SysRootUrl + "/aspx/";
            Html = Html.Replace("<!-lmname-!>", _MenuName).Replace("<!-lmid-!>", _MenuId.ToString());
            KstCmsBase.Entities.WebMenu_ent WebMenu = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(_MenuId, "GoUrl", "GoLmID", "AttRib");
                if (WebMenu.GoLmID != 0)
                {
                    switch (WebMenu.AttRib)
                    {
                        case 0:
                            KstCmsBase.Entities.WebLm_ent WebLm = KstCmsBase.DAL.WebLM.Get_WebLMInfo(WebMenu.GoLmID, "uPageFile");
                            if (WebExeute == 1)
                                Html = Html.Replace("<!-lmurl-!>", _LinkUrl + WebLm.uPageFile + HtmlExt);
                            else
                                Html = Html.Replace("<!-lmurl-!>", _LinkUrl + "uPage" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&LmId=" + WebMenu.GoLmID);
                            break;
                        case 1:
                            KstCmsBase.Entities.Product.ProLB_Ent Prolb = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(WebMenu.GoLmID, "LbID", "Alias");
                            if (WebExeute == 1)
                                Html = Html.Replace("<!-lmurl-!>", _LinkUrl + Prolb.Alias + "_0" + HtmlExt);
                            else
                            {
                                string ids = string.Empty;
                                KstCmsBase.DAL.Product.ProLB.GetAny_ParentLBID(WebMenu.GoLmID.ToString(), ref ids);
                                Html = Html.Replace("<!-lmurl-!>", _LinkUrl + "ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + ids);
                            }
                            break;
                        case 2:
                            KstCmsBase.Entities.Wz.WzLB_Ent Wzlb = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(WebMenu.GoLmID, "LbID", "FileName");
                            if (WebExeute == 1)
                                Html = Html.Replace("<!-lmurl-!>", _LinkUrl + Wzlb.FileName + "_0" + HtmlExt);
                            else
                                Html = Html.Replace("<!-lmurl-!>", _LinkUrl + "WzList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&Wzlbid=" + Wzlb.LbID);
                            break;
                    }

                }
                else
                {
                    if (WebExeute == 1)
                        Html = Html.Replace("<!-lmurl-!>", _LinkUrl + WebMenu.GoUrl + HtmlExt);
                    else
                        Html = Html.Replace("<!-lmurl-!>", _LinkUrl + "index" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId);
                }
                Html = Html.Replace("<!-lmurl-!>", _LinkUrl);
            return Html;
        }

        private string Get_ExtField(string ProId)
        {
            string Result = string.Empty;
            KstCmsBase.Collection.Product.PostFieldCollection FieldItems = KstCmsBase.DAL.Product.Product.GetPostFieldList(ProId);
            string html = string.Empty;
            foreach (KstCmsBase.Entities.Product.PostField_Ent Field in FieldItems)
            {
                html += "<tr>";
                html += "<td>" + Field.FieldName + ":</td><td>" + Field.FieldValue + "</td>";
                html += "</tr>";
            }
            if (!string.IsNullOrEmpty(html))
                Result = "<table>" + html + "</table>";
            return Result;
        }

        private string Get_ExtDescrition(string ProId)
        {
            string Result = string.Empty;
            return Result;
        }

        /// <summary>
        /// 时间格式化
        /// </summary>
        /// <param name="Code"></param>
        /// <returns></returns>
        private string Set_utimeFormat(int Code)
        {
            string Result = string.Empty;
            switch (Code)
            {
                case 0:
                    Result = string.Empty;
                    break;
                case 1:
                    Result = "{0:yyyy-MM-dd}"; ///2011-01-01
                    break;
                case 2:
                    Result = "{0:D}";///2011年1月1日
                    break;
                case 3:
                    Result = "{0:g}";
                    break;
                case 4:
                    Result = "{0:MM-dd}";
                    break;
                case 5:
                    Result = "{0:M}";
                    break;
            }
            return Result;
        }

    }
}
