﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using MVCBlogo.NET.BO;
using MVCBlogo.NET.DAL;

namespace MVCBlogo.NET.BLL
{

    public class BlogEntryManager
    {

        public static int CountAll(int StartRow, int PageSize)
        {
            return BlogEntryDB.CountAll(StartRow, PageSize);
        }


        public static int Count(int StartRow, int PageSize)
        {
            return BlogEntryDB.Count(StartRow, PageSize);
        }

        public static int CountTag(int TagID, int StartRow, int PageSize)
        {
            return BlogEntryDB.CountTag(TagID, StartRow, PageSize);
        }

        public static int CountType(Types type, int StartRow, int PageSize)
        {
            return BlogEntryDB.CountType(type, StartRow, PageSize);
        }

        public static int CountMonth(int year, int month, int StartRow, int PageSize)
        {
            return BlogEntryDB.CountMonth(year, month, StartRow, PageSize);
        }


        public static int CountUsedMonths(int StartRow, int PageSize)
        {
            return BlogEntryDB.CountUsedMonths(StartRow, PageSize);
        }

        public static List<BlogEntry> GetListAll(int StartRow, int PageSize)
        {
            return BlogEntryDB.GetListAll(StartRow, PageSize);
        }

        public static List<BlogEntry> GetList(int StartRow, int PageSize)
        {
            return BlogEntryDB.GetList(StartRow, PageSize);
        }

        public static List<BlogEntry> GetList()
        {
            return BlogEntryDB.GetList();
        }


        public static List<BlogEntry> GetListTag(int TagID, int StartRow, int PageSize)
        {
            return BlogEntryDB.GetListTag(TagID, StartRow, PageSize);
        }

        public static List<BlogEntry> GetListType(Types type, int StartRow, int PageSize)
        {
            return BlogEntryDB.GetListType(type, StartRow, PageSize);
        }

        public static List<BlogEntry> GetListMonth(int year, int month, int StartRow, int PageSize)
        {
            return BlogEntryDB.GetListMonth(year, month, StartRow, PageSize);
        }

        public static List<Month> GetListUsedMonths(int StartRow, int PageSize)
        {
            return BlogEntryDB.GetListUsedMonths(StartRow, PageSize);
        }

        public static BlogEntry GetItem(long id)
        {
            return BlogEntryDB.GetItem(id);
        }

        public static long Save(BlogEntry myBlogEntry)
        {
            return BlogEntryDB.Save(myBlogEntry);
        }

        public static bool Delete(BlogEntry myBlogEntry)
        {
            if (myBlogEntry != null)
                return BlogEntryDB.Delete(myBlogEntry.id);
            else
                return false;
        }

    }
}
