using System;
using System.Collections.Generic; 
using System.Linq;
using System.Web.Mvc.Html    ;


namespace Spencer
{
    public static class PageLinqExtensions
    {
        public static PagedList<T> ToPagedList<T>
            (
                this IQueryable<T> allItems,
                int? pageIndex,
                int pageSize
            )
        {
            return ToPagedList<T>(allItems, pageIndex, pageSize,null, String.Empty);

        }

        public static PagedList<T> ToPagedList<T>
            (
                this IQueryable<T> allItems,
                int? pageIndex,
                int pageSize, 
                string identityColumnName        
            )
        {
            return ToPagedList<T>(allItems, pageIndex, pageSize, identityColumnName, String.Empty);
        }

        public static PagedList<T> ToPagedList<T>
               (
                   this IQueryable<T> allItems,
                   int? pageIndex,
                   int pageSize,
                   string identityColumnName,
                   string sort
               )
        {
            var truePageIndex = pageIndex ?? 0;
            var itemIndex = truePageIndex * pageSize;
            var pageOfItems = allItems.Skip(itemIndex).Take(pageSize);
            var totalItemCount = allItems.Count();

            return new PagedList<T>(pageOfItems, truePageIndex, pageSize, totalItemCount,identityColumnName, sort);

        }

    }
}  

