﻿using System.Linq;
using System.Data.Linq;
using System.Collections.Generic;

using DataAccess.Mapping;
using MVCBlogo.NET.BO;

namespace MVCBlogo.NET.DAL
{

    public static class FileDB
    {
        private static BlogMapDataContext db = new BlogMapDataContext();

        public static int Count()
        {
            return db.files.Count();
        }

        public static int Count(int StartRow, int PageSize)
        {
            return db.files.Count();
        }

        public static File GetItem(long id)
        {

            files t = (from file in db.files where file.id == id select file).FirstOrDefault();
            return FillRecord(t, true);
        }

        public static List<File> GetList()
        {
            var query = from file in db.files orderby file.filename ascending select file;
            List<File> result = new List<File>();
            foreach (var t in query)
                result.Add(FillRecord(t, false));
            return result;
        }

        public static List<File> GetList(int StartRow, int PageSize)
        {
            var query = (from file in db.files orderby file.filename ascending select file).Skip(StartRow).Take(PageSize);
            List<File> result = new List<File>();
            foreach (var t in query)
                result.Add(FillRecord(t, false));
            return result;
        }

        public static long Save(File myFile)
        {
            files t = null;
            bool cont = false;
            long result = -1;

            // check if the filename does not already exist in the database
            files dupe = (from file in db.files where file.filename == myFile.filename select file).FirstOrDefault();
            cont = (dupe != null ? false : true); // if there is no duplicate record, continue processing

            if (cont)
            {
                try
                {
                    t = new files();
                    t.filename = myFile.filename;
                    t.mime = myFile.mime;
                    t.filecontent = myFile.filecontent;
                    db.files.InsertOnSubmit(t);
                    db.SubmitChanges();
                    result = t.id;
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                    result = t.id;
                }
            }
            return result;
        }

        public static bool Delete(long id)
        {
            files t = (from file in db.files where file.id == id select file).FirstOrDefault();
            if (t != null)
            {
                try
                {
                    db.files.DeleteOnSubmit(t);
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
            }
            return (t != null);
        }

        private static File FillRecord(files i, bool getFile)
        {
            File result = null;
            if (i != null)
            {
                result = new File();
                result.id = i.id;
                result.filename = i.filename;
                result.mime = i.mime;
                if (getFile)
                    result.filecontent = i.filecontent.ToArray();
            }
            return result;
        }
    }
}
