﻿using System;
using System.Linq;
using System.Data.Linq;
using System.Collections.Generic;
using DataAccess.Mapping;
using MVCBlogo.NET.BO;

namespace MVCBlogo.NET.DAL
{
    public static class LogDB
    {
        private static BlogMapDataContext db = new BlogMapDataContext();

        public static int Count(int StartRow, int PageSize)
        {
            return db.logs.Count();
        }

        public static Log GetItem(long id)
        {

            logs t = (from log in db.logs where log.id == id select log).FirstOrDefault();
            return FillRecord(t);
        }

        public static List<Log> GetList()
        {
            var query = from log in db.logs orderby log.date descending select log;
            List<Log> result = new List<Log>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }

        public static List<Log> GetList(int StartRow, int PageSize)
        {
            var query = (from log in db.logs orderby log.date descending select log).Skip(StartRow).Take(PageSize);
            List<Log> result = new List<Log>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }

        public static long Save(Log myLog)
        {
            logs t;
            long returncode = -1;
            t = new logs();
            t.date = System.DateTime.Now;
            t.@event = myLog.@event;
            try
            {db.logs.InsertOnSubmit(t);

                db.SubmitChanges();
                returncode = t.id;
            }
            catch (ChangeConflictException)
            {            db.logs.InsertOnSubmit(t);

                db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                db.SubmitChanges();
            }
            return t.id;
        }

        public static bool Delete(int id)
        {
            logs t = (from log in db.logs where log.id == id select log).FirstOrDefault();
            if (t != null)
            {
                try
                {
                    db.logs.DeleteOnSubmit(t);
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
            }
            return (t != null);
        }

        public static void DeleteAll()
        {
            try
            {
                db.logs.DeleteAllOnSubmit(db.logs);
                db.SubmitChanges();
            }
            catch (Exception)
            {
            }
        }

        private static Log FillRecord(logs i)
        {
            Log result = null;
            if (i != null)
            {
                result = new Log();
                result.id = i.id;
                result.date = Convert.ToDateTime(i.date);
                result.@event = i.@event;
            }
            return result;
        }
    }
}
