﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.Web.Configuration;

namespace Utils
{
    public static class BlogSettings
    {
        //读取网站的配置文件
        public static System.Configuration.Configuration config = System.Web.Configuration.WebConfigurationManager.OpenWebConfiguration(@"~");

    
        public static string BlogTitle
        {
            get
            {
                try
                {
                    return WebConfigurationManager.AppSettings["blogtitle"].ToString();//读取配置文件
                }
                catch (Exception)
                {
                    return "我的博客网站";
                }
            }
            set
            {
               
                config.AppSettings.Settings["blogtitle"].Value = value; //设置该节点的属性为新的一个值
            }
        }

        public static string RootPath
        {
            get
            {
                return WebConfigurationManager.AppSettings["rootpath"].ToString();
            }
            set
            {
                
                config.AppSettings.Settings["rootpath"].Value = value;
            }
        }

        public static int RSSPageSize
        {
            get
            {
                try
                {
                    return int.Parse(WebConfigurationManager.AppSettings["rsspagesize"].ToString());
                }
                catch (Exception)
                {
                    return 10;
                }
            }
            set
            {
                config.AppSettings.Settings["rsspagesize"].Value = value.ToString();
            }
        }

        public static long MaxFileSize
        {
            get
            {
                try
                {
                    return long.Parse(WebConfigurationManager.AppSettings["maxfilesize"].ToString());
                }
                catch (Exception)
                {
                    return 1048576;
                }
            }
            set
            {
                config.AppSettings.Settings["maxfilesize"].Value = value.ToString();
            }
        }

        public static string BlogDescription
        {
            get
            {
                return WebConfigurationManager.AppSettings["blogdescription"].ToString();
            }
            set
            {
                config.AppSettings.Settings["blogdescription"].Value = value.ToString();
            }
        }

        /// <summary>
        /// 将修改好的对象的属性保存到配置文件当中
        /// </summary>
        public static void Save()
        {
            config.Save();
        }
    }
}
