﻿using System;
using System.Web.Security;
using System.Web.Configuration;
using System.Security.Cryptography;

namespace Utils
{
    public static class Hash
    {

        public static string HashPassword(string password, string salt)
        {
            return FormsAuthentication.HashPasswordForStoringInConfigFile(salt + password, FormsAuthPasswordFormat.SHA1.ToString());
        }

        public static string GenerateSalt(int size)
        {
            RNGCryptoServiceProvider rng = new RNGCryptoServiceProvider();//使用加密服务来实现加密随机数
            byte[] buff = new byte[size];
            rng.GetBytes(buff);
            return Convert.ToBase64String(buff);
        }
    }
}
