﻿using System.Collections.Generic;
using System.Data.SqlClient;

namespace ynhtm.BLL
{
    using Common;
    using DBUtility;

    /// <summary>
    /// 栏目操作。
    /// </summary>
    public class Category
    {
        /// <summary>
        /// 插入栏目实例到数据库。
        /// </summary>
        /// <param name="item">栏目实例。</param>
        public void Insert(Model.Category item)
        {
            item.Url = item.Rewrite;
            DAL.Category.Insert(item);
            //没有重写地址，更新地址
            if (item.Url.IsNullOrWhiteSpace())
            {
                item.Url = "/Category/" + item.CategoryID;
                using (var db = DbBase.GetDb())
                    db.ExecuteNonQuery("UPDATE " + DAL.Category.SQL_TABLE + " SET " + DAL.Category.URL + " = @" + DAL.Category.URL + " WHERE " + DAL.Category.CATEGORYID + " = @" + DAL.Category.CATEGORYID, db.CreateParameter(DAL.Category.CATEGORYID, item.CategoryID), db.CreateParameter(DAL.Category.URL, item.Url));
            }
        }

        #region CategoryID

        /// <summary>
        /// 取得栏目实例。
        /// </summary>
        /// <param name="categoryID">栏目编号。</param>
        /// <returns>返回栏目实例，没有将返回 null 。</returns>
        public Model.Category GetByCategoryID(int categoryID)
        {
            return DAL.Category.GetByCategoryID(categoryID);
        }

        /// <summary>
        /// 更新栏目。
        /// </summary>
        /// <param name="item">栏目实例。</param>
        /// <returns>返回受到影响的行数。</returns>
        public int Update(Model.Category item)
        {
            //没有重写地址，更新地址
            item.Url = item.Rewrite.IifNullOrWhiteSpace("/Category/" + item.CategoryID);
            return DAL.Category.Update(item);
        }

        /// <summary>
        /// 删除栏目。
        /// </summary>
        /// <param name="categoryID">栏目编号。</param>
        /// <returns>返回受到影响的行数。</returns>
        public int Delete(int categoryID)
        {
            return DAL.Category.Delete(categoryID);
        }

        #endregion

        /// <summary>
        /// 取得所有栏目集合。
        /// </summary>
        /// <param name="orderType">排序方式。</param>
        /// <returns>返回栏目集合，无论是否有数据都将返回。</returns>
        public List<Model.Category> GetList(int orderType = 0)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Category.SQL_SELECT + " ORDER BY " + DAL.Category.DISPLAYORDER + (orderType != 0 ? " DESC" : " ASC")))
                {
                    var result = new List<Model.Category>();
                    while (reader.Read())
                    {
                        var item = new Model.Category();
                        DAL.Category.FillItem(reader, item);
                        result.Add(item);
                    }
                    return result;
                }
            }
        }

        /// <summary>
        /// 更新栏目名称和排序编号。
        /// </summary>
        /// <param name="categoryID">栏目编号。</param>
        /// <param name="name">栏目名称。</param>
        /// <param name="displayOrder">排序编号。</param>
        /// <returns>返回受到影响的行数。</returns>
        public int UpdateList(int categoryID, string name, int displayOrder)
        {
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery("UPDATE " + DAL.Category.SQL_TABLE + " SET " + DAL.Category.NAME + " = @" + DAL.Category.NAME + "," + DAL.Category.DISPLAYORDER + " = @" + DAL.Category.DISPLAYORDER + " WHERE " + DAL.Category.CATEGORYID + " = @" + DAL.Category.CATEGORYID, db.CreateParameter(DAL.Category.CATEGORYID, categoryID), db.CreateParameter(DAL.Category.NAME, name), db.CreateParameter(DAL.Category.DISPLAYORDER, displayOrder));
        }

        /// <summary>
        /// 统计栏目数据。
        /// </summary>
        /// <returns>返回受到影响的行数。</returns>
        public int Sumup()
        {
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery("UPDATE " + DAL.Category.SQL_TABLE + " SET " + DAL.Category.POSTCOUNT + " = (SELECT COUNT(0) FROM " + DAL.Post.SQL_TABLE + " WHERE " + DAL.Post.CATEGORYID + " = " + DAL.Category.SQL_TABLE + "." + DAL.Category.CATEGORYID + "), " + DAL.Category.COMMENTCOUNT + " = (SELECT " + db.IsNull + "(SUM(" + DAL.Post.COMMENTCOUNT + "), 0) FROM " + DAL.Post.SQL_TABLE + " WHERE " + DAL.Post.CATEGORYID + " = " + DAL.Category.SQL_TABLE + "." + DAL.Category.CATEGORYID + ")");
        }
    }
}
