﻿using System.Collections.Generic;

namespace ynhtm.BLL
{
    using DBUtility;

    /// <summary>
    /// 链接操作。
    /// </summary>
    public class Link
    {
        /// <summary>
        /// 插入链接实例到数据库。
        /// </summary>
        /// <param name="item">链接实例。</param>
        public void Insert(Model.Link item)
        {
            DAL.Link.Insert(item);
        }

        #region LinkID

        /// <summary>
        /// 取得链接实例。
        /// </summary>
        /// <param name="linkID">链接编号。</param>
        /// <returns>返回链接实例，没有将返回 null 。</returns>
        public Model.Link GetByLinkID(int linkID)
        {
            return DAL.Link.GetByLinkID(linkID);
        }

        /// <summary>
        /// 更新链接。
        /// </summary>
        /// <param name="item">链接实例。</param>
        /// <returns>返回受到影响的行数。</returns>
        public int Update(Model.Link item)
        {
            return DAL.Link.Update(item);
        }

        /// <summary>
        /// 删除链接。
        /// </summary>
        /// <param name="linkID">链接编号。</param>
        /// <returns>返回受到影响的行数。</returns>
        public int Delete(int linkID)
        {
            return DAL.Link.Delete(linkID);
        }

        #endregion

        /// <summary>
        /// 取得所有链接集合。
        /// </summary>
        /// <param name="orderType">排序方式。</param>
        /// <returns>返回链接集合，无论是否有数据都将返回。</returns>
        public List<Model.Link> GetList(int orderType = 0)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Link.SQL_SELECT + " ORDER BY " + DAL.Link.DISPLAYORDER + (orderType != 0 ? " DESC" : " ASC")))
                {
                    var result = new List<Model.Link>();
                    while (reader.Read())
                    {
                        var item = new Model.Link();
                        DAL.Link.FillItem(reader, item);
                        result.Add(item);
                    }
                    return result;
                }
            }
        }
    }
}
