﻿using System.Security.Principal;
using System.Web;
using System.Web.Script.Serialization;
using System.Web.SessionState;
using System.Xml;

namespace ynhtm.Common
{
    public abstract class BaseHandler : IHttpHandler, IRequiresSessionState
    {
        public virtual void ProcessRequest(HttpContext context)
        {
            this.Request = context.Request;
            (this.Response = context.Response).ContentType = "text/html";
            this.Server = context.Server;
            this.Session = context.Session;
            this.User = context.User;
            this.Process();
        }

        public abstract void Process();

        public virtual HttpRequest Request { get; private set; }

        public virtual HttpResponse Response { get; private set; }

        public virtual HttpServerUtility Server { get; private set; }

        public virtual HttpSessionState Session { get; private set; }

        public virtual IPrincipal User { get; private set; }

        public virtual void WriteJSON(object value)
        {
            this.Response.ContentType = "application/json";
            this.Response.Write(new JavaScriptSerializer().Serialize(value));
            this.Response.End();
        }

        public virtual XmlTextWriter OutputXml
        {
            get
            {
                this.Response.ContentType = "text/xml";
                return new XmlTextWriter(this.Response.Output);
            }
        }

        public virtual bool IsReusable
        {
            get { return false; }
        }
    }
}
