﻿using System;
using System.Collections.Generic;
using System.Data;

namespace ynhtm.DBUtility
{
    public static class Table
    {
        public static List<TModel> ToList<TModel>(this DataTable table, Action<IDataReader, TModel> fill)
        {
            using (var reader = table.CreateDataReader())
            {
                var result = new List<TModel>();
                while (reader.Read())
                {
                    var item = Activator.CreateInstance<TModel>();
                    fill.Invoke(reader, item);
                    result.Add(item);
                }
                return result;
            }
        }
    }
}
