﻿using System;
using System.Web.Razor;

namespace ynhtm.Theme
{
    using Common;
    using Template;

    public static class Parser
    {
        internal static readonly Configuration.ConfigurationSection CONFIG;
        internal static readonly Configuration.ConfigurationSectionWap CONFIGWAP;

        internal static readonly Template.IListProvider LISTPROVIDER;

        static Parser()
        {
            CONFIG = Configuration.ConfigurationSection.GetConfig();
            CONFIGWAP = Configuration.ConfigurationSectionWap.GetConfig();
            if (CONFIG != null && !CONFIG.ListProviderType.IsNullOrWhiteSpace())
                LISTPROVIDER = (Template.IListProvider)Activator.CreateInstance(Type.GetType(CONFIG.ListProviderType));
            else
                LISTPROVIDER = new Template.ListProvider();
        }

        public static string Parse(string path, Type templateType, RazorCodeLanguage language = null, Action<object> activator = null)
        {
            return Muban.Parser.Parse(path, templateType, language, activator);
        }

        public static string Parse<T>(string path, RazorCodeLanguage language = null, Action<T> activator = null) where T : ITemplate
        {
            return Muban.Parser.Parse<T>(path, language, activator);
        }
    }
}
