﻿using System;
using System.Collections.Generic;
using System.Security.Principal;
using System.Web;
using System.Web.SessionState;

namespace ynhtm.Theme.Template
{
    using Common;
    using DBUtility;

    /// <summary>
    /// 基本页面模板。
    /// </summary>
    public abstract class TemplateBase<TModel> : TemplateBase, ITemplate<TModel>
    {
        /// <summary>
        /// 页面数据实体。
        /// </summary>
        public TModel Model { get; set; }
    }

    /// <summary>
    /// 基本页面模板。
    /// </summary>
    public abstract class TemplateBase : Muban.Template.FileTemplate, ITemplate
    {
        /// <summary>
        /// 初始化方法。
        /// </summary>
        public TemplateBase()
        {
            this.Setting = new BLL.Setting().Get();
        }

        #region 公共属性

        /// <summary>
        /// 获取网站设置信息。
        /// </summary>
        public Model.Setting Setting { get; private set; }

        /// <summary>
        /// 获取请求的页的 System.Web.HttpRequest 对象。
        /// </summary>
        public IPrincipal User { get; set; }

        /// <summary>
        /// 客户端 Web 请求。
        /// </summary>
        public HttpRequest Request { get; set; }

        /// <summary>
        /// 获取与该模板关联的 System.Web.HttpResponse 对象。该对象使您得以将 HTTP 响应数据发送到客户端，并包含有关该响应的信息。
        /// </summary>
        public HttpResponse Response { get; set; }

        /// <summary>
        /// 获取模板提供的当前 Session 对象。
        /// </summary>
        public HttpSessionState Session { get; set; }

        #endregion

        /// <summary>
        /// 合并指定路径的文件地址。
        /// </summary>
        /// <param name="path">要合并的文件路径。</param>
        /// <returns>返回该文件的地址。</returns>
        public string Href(string path)
        {
            return Utils.Combine(this.Request.Path, path);
        }

        /// <summary>
        /// 判断路径是否是当前请求的路径。
        /// </summary>
        /// <param name="path">要判断的路径（虚拟路径）。</param>
        /// <returns>如果路径相同返回 true。</returns>
        public bool IsUrl(string path)
        {
            if (string.Equals(path, this.Request.Path, StringComparison.OrdinalIgnoreCase)) return true;
            return string.Equals(path.TrimEnd('/') + '/', this.Request.Path.TrimEnd('/') + '/', StringComparison.OrdinalIgnoreCase);
        }

        /// <summary>
        /// 获取指定数量的文章。
        /// </summary>
        /// <param name="count">文章数量（必须）。</param>
        /// <param name="isTop">推荐的。</param>
        /// <param name="isPic">包含图片。</param>
        /// <param name="isFace">包含封面。</param>
        /// <param name="categoryIDs">栏目编号集合。</param>
        /// <param name="order">排序方式。</param>
        /// <returns>返回文章集合，无论是否包含符合条件的文章都返回。</returns>
        public virtual List<Model.Post> GetList(int count, bool? isTop = null, bool? isPic = null, bool? isFace = null, int[] categoryIDs = null, string order = "ORDER BY " + DAL.Post.ISTOP + " DESC," + DAL.Post.POSTID + " DESC")
        {
            var post = new BLL.Post();
            var query = DbBase.GetQuery().Equal(DAL.Post.ENABLED, true).And().NotEqual(DAL.Post.ISHIDE, true);
            if (isTop != null) query.And().Equal(DAL.Post.ISTOP, isTop.Value);
            if (isPic != null) query.And().Equal(DAL.Post.ISPIC, isPic.Value);
            if (isFace != null) query.And().Equal(DAL.Post.ISFACE, isFace.Value);
            if (categoryIDs != null && categoryIDs.Length > 0) query.And().In(DAL.Post.CATEGORYID, categoryIDs);
            return post.GetList(count, 1, query, order).ToList<Model.Post>(DAL.Post.FillItem);
        }
    }
}
