﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace ynhtm.WebControls
{
    /// <summary>
    /// Repeater 控件。
    /// </summary>
    [ToolboxData("<{0}:Repeater runat=\"server\"></{0}:Repeater>")]
    public class Repeater : System.Web.UI.WebControls.Repeater
    {
        ITemplate emptyTemplate;
        /// <summary>
        /// 数据为空的模板。
        /// </summary>
        [Browsable(false)]
        [PersistenceMode(PersistenceMode.InnerProperty)]
        [TemplateContainer(typeof(RepeaterItem))]
        [WebSysDescription("View_EmptyDataTemplate")]
        [DefaultValue((string)null)]
        public virtual ITemplate EmptyTemplate
        {
            get { return this.emptyTemplate; }
            set { this.emptyTemplate = value; }
        }

        /// <summary>
        /// 创建一个带或不带指定数据源的控件层次结构。
        /// </summary>
        /// <param name="useDataSource">指示是否要使用指定的数据源。</param>
        protected override void CreateControlHierarchy(bool useDataSource)
        {
            base.CreateControlHierarchy(useDataSource);
            if (useDataSource && this.Items.Count == 0)
            {
                this.Controls.Clear();
                if (this.emptyTemplate != null) this.emptyTemplate.InstantiateIn(this);
            }
        }
    }
}
