﻿using System.Globalization;
using System.Reflection;
using System.Resources;
using System.Threading;

namespace ynhtm.WebControls
{
    class SR
    {
        static SR loader;
        ResourceManager resources;
        static object internalSyncObject;

        internal SR()
        {
            this.resources = new ResourceManager("System.Web", Assembly.GetAssembly(typeof(System.Web.UI.WebControls.WebControl)));
        }

        static object InternalSyncObject
        {
            get
            {
                if (internalSyncObject == null) Interlocked.CompareExchange(ref internalSyncObject, new object(), null);
                return internalSyncObject;
            }
        }

        static SR GetLoader()
        {
            if (loader == null)
            {
                lock (InternalSyncObject)
                {
                    if (loader == null) loader = new SR();
                }
            }
            return loader;
        }

        public static string GetString(string name)
        {
            SR loader = GetLoader();
            if (loader == null) return null;
            return loader.resources.GetString(name);
        }

        public static string GetString(string name, params object[] args)
        {
            SR loader = GetLoader();
            if (loader == null) return null;
            string format = loader.resources.GetString(name);
            if ((args == null) || (args.Length <= 0)) return format;
            for (int i = 0; i < args.Length; i++)
            {
                string str2 = args[i] as string;
                if (str2 != null && str2.Length > 0x400) args[i] = str2.Substring(0, 0x3fd) + "...";
            }
            return string.Format(CultureInfo.CurrentCulture, format, args);
        }
    }
}