﻿using System.ComponentModel;

namespace ynhtm.WebControls
{
    sealed class WebCategoryAttribute : CategoryAttribute
    {
        internal WebCategoryAttribute(string category)
            : base(category)
        {
        }

        protected override string GetLocalizedString(string value)
        {
            var s = base.GetLocalizedString(value);
            if (s == null) s = SR.GetString("Category_" + value);
            return s;
        }

        public override object TypeId
        {
            get { return typeof(CategoryAttribute); }
        }
    }
}