﻿using System.ComponentModel;

namespace ynhtm.WebControls
{
    sealed class WebSysDescriptionAttribute : DescriptionAttribute
    {
        bool replaced = false;
        internal WebSysDescriptionAttribute(string description)
            : base(description)
        {
        }

        public override string Description
        {
            get
            {
                if (!this.replaced)
                {
                    base.DescriptionValue = SR.GetString(base.Description);
                    this.replaced = true;
                }
                return base.Description;
            }
        }

        public override object TypeId
        {
            get { return typeof(DescriptionAttribute); }
        }
    }
}
