﻿using System.Web;
using System.Web.Script.Serialization;

namespace ynhtm.API
{
    using Common;

    public class Job : BaseHandler
    {
        public override void Process()
        {
            var request = this.Request;
            var response = this.Response;
            response.Clear();
            response.Cache.SetCacheability(HttpCacheability.NoCache);
            response.Cache.SetNoStore();
            switch (request["Action"])
            {
                case "TryPost":
                    this.TryPost();
                    break;
            }
        }

        void TryPost()
        {
            var request = this.Request;
            var response = this.Response;
            var jobTry = new BLL.JobTry();
            var result = jobTry.Post(request, response, this.Session, this.Server);
            if (request["Ajax"] == "1")
            {
                this.WriteJSON(result);
            }
            else if (request["Frame"] == "1")
            {
                response.Write("<script type=\"text/javascript\">parent.$.Job.Try._complete(" + new JavaScriptSerializer().Serialize(result) + ");</script>");
                response.End();
            }
            else
                response.Redirect(request["Url"] ?? request.UrlReferrer.ToString());
        }
    }
}