﻿using System;
using System.Drawing;
using System.Web;

namespace ynhtm.API
{
    using Common;

    public class Thumb : BaseHandler
    {
        public override void Process()
        {
            var request = this.Request;
            var response = this.Response;
            var path = new Uri(request.Url, request.QueryString["Url"]).LocalPath;
            response.Clear();
            response.Cache.SetExpires(DateTime.Now.AddMonths(1));
            response.Cache.SetCacheability(HttpCacheability.Private);
            response.Buffer = true;
            response.ContentType = "image/jpeg";
            response.Charset = null;
            using (var img = Image.FromFile(this.Server.MapPath(path)))
            {
                var size = (Size)new SizeConverter().ConvertFromString(request.QueryString["Size"]);
                using (var thumb = Img.Thumb(img, size, (ImageThumbMode)Enum.Parse(typeof(ImageThumbMode), request.QueryString["Mode"] ?? "Auto", true), ContentAlignment.MiddleCenter))
                    thumb.SaveJpeg(long.Parse(request.QueryString["Quality"] ?? "80"), response.OutputStream);
            }
            response.End();
        }
    }
}