﻿using System.Web;
using System.Web.Security;

namespace ynhtm.API
{
    using Common;

    public class User : BaseHandler
    {
        public override void Process()
        {
            var response = this.Response;
            response.Clear();
            response.Cache.SetCacheability(HttpCacheability.NoCache);
            response.Cache.SetNoStore();
            switch (this.Request["Action"])
            {
                case "Logout":
                    FormsAuthentication.SignOut();
                    break;
                case "Info":
                    this.Info();
                    break;
            }
        }

        void Info()
        {
            var id = this.User.Identity;
            if (id.IsAuthenticated && id.AuthenticationType == "Forms")
            {
                var user = ((Model.IPrincipal)this.User).User;
                object info;
                if (user.IsLock)
                    info = new { Code = -1, Msg = "用户被锁定" };
                else
                    info = new { Code = 0, user.UserID, user.UserName, user.RealName, user.Email };
                this.WriteJSON(info);
            }
            else
                this.WriteJSON(null);
        }
    }
}