﻿using System.Web;

namespace ynhtm.API
{
    using Common;

    public class View : BaseHandler
    {
        public override void Process()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            var request = this.Request;
            var response = this.Response;
            response.Clear();
            response.Cache.SetCacheability(HttpCacheability.NoCache);
            response.Cache.SetNoStore();
            response.ContentType = "application/x-javascript";
            var isClick = request["Click"] != "0";
            var isOut = request["Out"] != "0";
            var count = 0;
            if (request["Type"] == "Job")
            {
                var job = new BLL.Job();
                var jobID = int.Parse(request["JobID"]);
                if (isClick) job.IncViewCount(jobID, request, response);
                if (isOut) count = job.GetViewCount(jobID);
            }
            else
            {
                var post = new BLL.Post();
                var postID = int.Parse(request["PostID"]);
                if (isClick) post.IncViewCount(postID, request, response);
                if (isOut) count = post.GetViewCount(postID);
            }
            if (isOut)
            {
                if (request["Ajax"] == "1")
                    this.WriteJSON(count);
                else
                    response.Write("document.write(" + count + ");");
            }
            response.End();
        }
    }
}