﻿<%@ Page Title="评论管理 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="CommentList.aspx.cs" Inherits="ynhtm.Admin.CommentList" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        评论管理</h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        搜索</h2>
    <asp:Panel runat="server" DefaultButton="btnSearch" CssClass="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtName">用户:</asp:Label><br />
                    <asp:TextBox ID="txtName" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtEmail">邮件地址:</asp:Label><br />
                    <asp:TextBox ID="txtEmail" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtIPAddr">IP地址:</asp:Label><br />
                    <asp:TextBox ID="txtIPAddr" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropIsAudit">审核:</asp:Label><br />
                    <asp:DropDownList ID="dropIsAudit" runat="server" AppendDataBoundItems="true" Width="250px">
                        <asp:ListItem Value="">(不限)</asp:ListItem>
                        <asp:ListItem Value="true">审核的</asp:ListItem>
                        <asp:ListItem Value="false">待审核</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" CausesValidation="false"
                        UseSubmitBehavior="false" Text="搜索" />
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <table class="list list-space" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th style="width: 220px;">
                    用户
                </th>
                <th>
                    评论
                </th>
            </tr>
        </thead>
        <tbody>
            <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                <EmptyTemplate>
                    <tr class="list-empty">
                        <td colspan="2">
                            没有任何评论
                        </td>
                    </tr>
                </EmptyTemplate>
                <ItemTemplate>
                    <tr>
                        <td valign="top">
                            <asp:HiddenField ID="hidSelectID" runat="server" Value='<%#this.Eval("CommentID")%>' />
                            <asp:CheckBox ID="chkSelect" runat="server" Text="<%#this.EvalName%>" Font-Bold="true" /><br />
                            <a href="<%#this.Eval("Email", "mailto:{0}")%>">
                                <%#this.EvalEmail%></a><br />
                            <%#this.EvalIPAddr%>
                            <a href="<%#this.Eval("IPAddr", "http://ip138.com/ips.asp?ip={0}")%>" class="b" target="_blank">
                                追踪</a>
                        </td>
                        <td valign="top">
                            <%#this.Eval<bool>("IsAudit") ? "<span class=\"green\">审核的</span>" : "<span class=\"orange\">待审核</span>"%>
                            <strong><a href="<%#this.Eval("PostUrl", "{0}#comment")%>" target="_blank">
                                <%#this.Eval<string>("PostTitle").HtmlEncode()%></a></strong> <span class="gray">
                                    <%#this.Eval("PostDate", "{0:f}")%></span>
                            <div class="list-content">
                                <%#this.Eval<string>("Content").HtmlDel().HtmlWrap()%>
                                <div class="list-cmd">
                                    <asp:LinkButton runat="server" CausesValidation="false" CommandName="AuditToggle"
                                        CommandArgument='<%#this.Eval("CommentID")%>'><%#this.Eval<bool>("IsAudit") ? "驳回" : "审核"%></asp:LinkButton>
                                    |
                                    <asp:LinkButton runat="server" CausesValidation="false" CommandName="Del" CommandArgument='<%#this.Eval("CommentID")%>'
                                        OnClientClick="javascript:if(!confirm('确认删除该评论吗？')) return false;">删除</asp:LinkButton>
                                    | <a href="" onclick="javascript:$(this).closest('.list-content').hide().next('.list-edit').show(); return false;">
                                        编辑</a></div>
                            </div>
                            <asp:Panel runat="server" CssClass="list-edit hide" DefaultButton="btnOK">
                                <ul>
                                    <li>
                                        <asp:TextBox ID="txtContent" runat="server" TextMode="MultiLine" Width="90%" Height="60px"
                                            Text='<%#this.Eval("Content")%>'></asp:TextBox></li><li>
                                                <asp:Button ID="btnOK" runat="server" Text="确定" CausesValidation="false" UseSubmitBehavior="false"
                                                    CommandName="Edit" CommandArgument='<%#this.Eval("CommentID")%>' />
                                                <input type="button" value="取消" class="btn" onclick="javascript:$(this).closest('.list-edit').hide().prev('.list-content').show();" /></li></ul>
                            </asp:Panel>
                        </td>
                    </tr>
                </ItemTemplate>
            </YNHTM:Repeater>
        </tbody>
    </table>
    <div class="command">
        <YNHTM:Pager ID="pager" runat="server" OnPageIndexChanged="pager_PageIndexChanged">
        </YNHTM:Pager>
        <input type="button" onclick="javascript:$(':checkbox').attr('checked', true);" class="btn"
            value="全选" />
        <input type="button" onclick="javascript:$(':checkbox').attr('checked', function(){ return !this.checked; });"
            class="btn" value="反选" />
        |
        <asp:Button ID="btnSelDelete" runat="server" OnClick="btnSelDelete_Click" CausesValidation="false"
            UseSubmitBehavior="false" Text="删除选中" OnClientClick="javascript:if(!confirm('确认删除选中评论吗？')) return false;" />
        <asp:Button ID="btnSelReject" runat="server" OnClick="btnSelReject_Click" CausesValidation="false"
            UseSubmitBehavior="false" Text="驳回选中" />
        <asp:Button ID="btnSelAudit" runat="server" OnClick="btnSelAudit_Click" CausesValidation="false"
            UseSubmitBehavior="false" Text="审核选中" />
    </div>
</asp:Content>
