﻿using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;
    using DBUtility;

    public partial class CommentList : System.Web.UI.Page
    {
        void PageBind()
        {
            var recordCount = 0;
            var comment = new BLL.Comment();
            var query = DbBase.GetQuery();
            var key = this.txtName.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.Comment.NAME, key);
            key = this.txtEmail.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.Comment.EMAIL, key);
            key = this.txtIPAddr.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.Comment.IPADDR, key);
            var isAudit = this.dropIsAudit.TryGet(bool.Parse);
            if (isAudit != null) query.And().Equal(DAL.Comment.ISAUDIT, isAudit);
            this.rptList.DataSource = comment.GetList(ref recordCount, this.pager.PageSize, this.pager.PageIndex, query);
            this.rptList.DataBind();
            this.pager.RecordCount = recordCount;
        }

        List<int> GetSelectItem()
        {
            var result = new List<int>();
            foreach (RepeaterItem i in this.rptList.Items)
            {
                var id = i.FindControl("hidSelectID") as HiddenField;
                if (id != null && ((CheckBox)i.FindControl("chkSelect")).Checked) result.Add(int.Parse(id.Value));
            }
            return result;
        }

        protected string EvalName
        {
            get
            {
                var key = this.txtName.Text;
                var name = this.Eval<string>(DAL.Comment.NAME);
                if (!key.IsNullOrWhiteSpace()) name = name.Highlight(key);
                return name.IifNullOrWhiteSpace("(匿名)");
            }
        }

        protected string EvalEmail
        {
            get
            {
                var key = this.txtEmail.Text;
                var email = this.Eval<string>(DAL.Comment.EMAIL);
                if (key.IsNullOrWhiteSpace()) return email;
                return email.Highlight(key);
            }
        }

        protected string EvalIPAddr
        {
            get
            {
                var s = this.txtIPAddr.Text;
                var ipAddr = this.Eval<string>(DAL.Comment.IPADDR);
                if (s.IsNullOrWhiteSpace()) return ipAddr;
                return ipAddr.Highlight(s.HtmlEncode());
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.PageBind();
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            this.PageBind();
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            var comment = new BLL.Comment();
            if (e.CommandName == "Del")
            {
                comment.Delete(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("删除评论成功");
            }
            else if (e.CommandName == "Edit")
            {
                var item = comment.GetByCommentID(Convert.ToInt32(e.CommandArgument));
                item.Content = ((TextBox)e.Item.FindControl("txtContent")).Text;
                comment.Update(item);
                this.PageBind();
                this.ShowInfo("编辑评论成功");
            }
            else if (e.CommandName == "AuditToggle")
            {
                comment.AuditToggle(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("切换审核成功");
            }
        }

        protected void pager_PageIndexChanged(object sender, EventArgs e)
        {
            this.PageBind();
        }

        protected void btnSelDelete_Click(object sender, EventArgs e)
        {
            var comment = new BLL.Comment();
            foreach (var i in this.GetSelectItem())
                comment.Delete(i);
            this.PageBind();
            this.ShowInfo("删除选中评论成功");
        }

        protected void btnSelReject_Click(object sender, EventArgs e)
        {
            var comment = new BLL.Comment();
            comment.Audit(this.GetSelectItem().ToArray(), false);
            this.PageBind();
            this.ShowInfo("驳回选中评论成功");
        }

        protected void btnSelAudit_Click(object sender, EventArgs e)
        {
            var comment = new BLL.Comment();
            comment.Audit(this.GetSelectItem().ToArray(), true);
            this.PageBind();
            this.ShowInfo("审核选中评论成功");
        }
    }
}