﻿<%@ Page Title="数据管理 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="Database.aspx.cs" Inherits="ynhtm.Admin.Database" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        数据管理</h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        数据库信息</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    名称:
                    <asp:Label ID="lblName" runat="server"></asp:Label>
                </td>
            </tr>
            <tr>
                <td>
                    大小:
                    <asp:Label ID="lblSize" runat="server"></asp:Label>
                </td>
            </tr>
            <tr>
                <td>
                    版本:
                    <asp:Label ID="lblVersion" runat="server"></asp:Label>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnBackup" runat="server" OnClick="btnBackup_Click" CausesValidation="false"
                        UseSubmitBehavior="false" Text="备份数据" />
                </td>
            </tr>
        </table>
    </div>
    <h2>
        SQL 语句执行 <span class="hit">仅返回受影响行数</span></h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:TextBox ID="txtSQL" runat="server" Width="250px" Height="200px" TextMode="MultiLine"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnSQL" runat="server" OnClick="btnSQL_Click" CausesValidation="false"
                        UseSubmitBehavior="false" Text="执行语句" OnClientClick="javascript:if(!confirm('确认执行语句吗？')) return false;" />
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <table class="list" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th>
                    备份文件
                </th>
                <th style="width: 100px;" class="center">
                    大小
                </th>
                <th style="width: 130px;" class="center">
                    备份时间
                </th>
                <th style="width: 80px;" class="center">
                    操作
                </th>
            </tr>
        </thead>
        <tbody>
            <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                <EmptyTemplate>
                    <tr class="list-empty">
                        <td colspan="4">
                            没有进行过备份
                        </td>
                    </tr>
                </EmptyTemplate>
                <ItemTemplate>
                    <tr>
                        <td>
                            <%#this.Eval("FullName")%>
                        </td>
                        <td class="center">
                            <%#this.EvalLength%>
                        </td>
                        <td class="center">
                            <%#this.Eval("CreationTime", "{0:f}")%>
                        </td>
                        <td class="center gray">
                            <a href="?Action=Down&amp;FileName=<%#this.Eval<string>("Name").UrlEncode()%>" class="b">下载</a>
                            |
                            <asp:LinkButton runat="server" CssClass="b" CausesValidation="false" CommandName="Del" CommandArgument='<%#this.Eval("Name")%>'
                                OnClientClick="javascript:if(!confirm('确认删除该备份吗？')) return false;">删除</asp:LinkButton>
                        </td>
                    </tr>
                </ItemTemplate>
            </YNHTM:Repeater>
        </tbody>
    </table>
</asp:Content>
