﻿using System;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;

namespace ynhtm.Admin
{
    using Common;

    public partial class JobEdit : Upfile
    {
        void ControlBind()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            var dir = new DirectoryInfo(this.MapPath("~/Theme/" + settingItem.Theme.IifNullOrWhiteSpace("Default")));
            if (dir.Exists)
            {
                var files = dir.GetFiles();
                foreach (var i in files.Where(i => i.Name.StartsWith("Job", StringComparison.OrdinalIgnoreCase) && Regex.IsMatch(i.Extension, @"\.(cshtml|vbhtml)$", RegexOptions.Compiled | RegexOptions.IgnoreCase))) this.dropTheme.Items.Add(i.Name);
            }

            this.dropType.DataValueField = "Key";
            this.dropType.DataTextField = "Value";
            this.dropType.DataSource = BLL.Job.TYPES;
            this.dropType.DataBind();

            this.dropSex.DataValueField = "Key";
            this.dropSex.DataTextField = "Value";
            this.dropSex.DataSource = BLL.Job.SEXS;
            this.dropSex.DataBind();

            this.dropDegree.DataValueField = "Key";
            this.dropDegree.DataTextField = "Value";
            this.dropDegree.DataSource = BLL.Job.DEGREES;
            this.dropDegree.DataBind();

            this.dropExperience.DataValueField = "Key";
            this.dropExperience.DataTextField = "Value";
            this.dropExperience.DataSource = BLL.Job.EXPERIENCES;
            this.dropExperience.DataBind();
        }

        void ControlReset()
        {
            this.txtName.Text = "";
        }

        void SetValue(Model.Job item)
        {
            item.Name = this.txtName.Text;
            item.Rewrite = this.txtRewrite.Text;
            item.Theme = this.dropTheme.Text;
            item.Content = this.txtContent.Text;
            item.Enabled = this.chkEnabled.Checked;

            item.Type = this.dropType.TryGet(int.Parse);
            item.Area = this.txtArea.Text;
            item.Count = this.txtCount.TryGet(int.Parse);
            item.Salary = this.txtSalary.TryGet(decimal.Parse);
            item.Sex = this.dropSex.TryGet(int.Parse);
            item.Age = this.txtAge.TryGet(int.Parse);
            item.Degree = this.dropDegree.TryGet(int.Parse);
            item.Experience = this.dropExperience.TryGet(int.Parse);
            item.EndDate = this.txtEndDate.TryGet(DateTime.Parse);
        }

        void AddBegin()
        {
            this.ViewState["KeyID"] = null;
            this.Title = "发布职位 - 管理中心";
            this.lblTitle.Text = "发布职位";
            this.btnEdit.Text = "发布";
        }

        Model.Job AddEnd()
        {
            var item = new Model.Job();
            this.SetValue(item);
            var job = new BLL.Job();
            job.Insert(item);
            return item;
        }

        void EditBegin(int keyID)
        {
            this.ViewState["KeyID"] = keyID;
            this.Title = "编辑职位 - 管理中心";
            this.lblTitle.Text = "编辑职位";
            this.btnEdit.Text = "编辑";

            var post = new BLL.Job();
            var item = post.GetByJobID(keyID);

            this.txtName.Text = item.Name;
            this.txtRewrite.Text = item.Rewrite;
            this.dropTheme.SelectValue(item.Theme);
            this.txtContent.Text = item.Content;

            this.chkEnabled.Checked = item.Enabled;
            this.dropType.SelectValue(item.Type.ToString());
            this.txtArea.Text = item.Area;
            this.txtCount.Text = item.Count.ToString();
            this.txtSalary.Text = item.Salary != null ? item.Salary.Value.ToString("#.##") : "";
            this.dropSex.SelectValue(item.Sex.ToString());
            this.txtAge.Text = item.Age.ToString();
            this.dropDegree.SelectValue(item.Degree.ToString());
            this.dropExperience.SelectValue(item.Experience.ToString());
            this.txtEndDate.Text = item.EndDate != null ? item.EndDate.Value.ToString("yyy-MM-dd") : "";
        }

        Model.Job EditEnd()
        {
            var job = new BLL.Job();
            var item = job.GetByJobID(Convert.ToInt32(this.ViewState["KeyID"]));
            this.SetValue(item);
            job.Update(item);
            return item;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            this.Form.DefaultButton = this.btnEdit.UniqueID;
            this.ClientScript.RegisterClientScriptVar(this.GetType(), "Page", "Page", new { ContentID = this.txtContent.ClientID });
            if (!this.IsPostBack)
            {
                this.ControlBind();
                var s = this.Request["JobID"];
                if (s.IsNullOrWhiteSpace())
                    this.AddBegin();
                else
                    this.EditBegin(int.Parse(s));
            }
            base.Page_Load(sender, e);
        }

        protected void btnEdit_Click(object sender, EventArgs e)
        {
            if (this.IsValid)
            {
                var s = "";
                Model.Job item;
                if (this.ViewState["KeyID"] == null)
                {
                    item = this.AddEnd();
                    this.ControlReset();
                    s = "发布职位成功";
                }
                else
                {
                    item = this.EditEnd();
                    s = "编辑职位成功";
                }
                if (this.chkEnabled.Checked) s += " <a href=\"" + item.Url + "\" target=\"_blank\">查看 &gt; &gt;</a>";
                this.ShowInfo(s);
            }
        }
    }
}