﻿using System;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;
    using DBUtility;

    public partial class JobList : System.Web.UI.Page
    {
        void PageBind()
        {
            var recordCount = 0;
            var job = new BLL.Job();
            var query = DbBase.GetQuery();
            var key = this.txtName.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.Job.NAME, key);
            key = this.txtArea.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.Job.AREA, key);
            this.rptList.DataSource = job.GetList(ref recordCount, this.pager.PageSize, this.pager.PageIndex, query);
            this.rptList.DataBind();
            this.pager.RecordCount = recordCount;
        }

        protected string EvalName
        {
            get
            {
                var key = this.txtName.Text;
                var name = this.Eval<string>(DAL.Job.NAME).HtmlEncode();
                if (key.IsNullOrWhiteSpace()) return name;
                return name.Highlight(key.HtmlEncode());
            }
        }

        protected string EvalArea
        {
            get
            {
                var key = this.txtArea.Text;
                var area = this.Eval<string>(DAL.Job.AREA).HtmlEncode();
                if (key.IsNullOrWhiteSpace()) return area;
                return area.Highlight(key.HtmlEncode());
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.PageBind();
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            this.PageBind();
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            var job = new BLL.Job();
            if (e.CommandName == "Del")
            {
                job.Delete(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("删除职位成功");
            }
            else if (e.CommandName == "EnabledToggle")
            {
                job.EnabledToggle(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("切换职位状态成功");
            }
        }

        protected void pager_PageIndexChanged(object sender, EventArgs e)
        {
            this.PageBind();
        }
    }
}