﻿using System;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;
    using DBUtility;

    public partial class JobTryList : System.Web.UI.Page
    {
        void PageBind()
        {
            var recordCount = 0;
            var jobTry = new BLL.JobTry();
            var query = DbBase.GetQuery();
            var key = this.txtRealName.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.JobTry.SQL_TABLE + "." + DAL.JobTry.REALNAME, key);
            key = this.txtJobName.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.Job.SQL_TABLE + "." + DAL.Job.NAME, key);
            key = this.txtContact.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.JobTry.SQL_TABLE + "." + DAL.JobTry.CONTACT, key);
            this.rptList.DataSource = jobTry.GetList(ref recordCount, this.pager.PageSize, this.pager.PageIndex, query);
            this.rptList.DataBind();
            this.pager.RecordCount = recordCount;
        }

        protected string EvalRealName
        {
            get
            {
                var key = this.txtRealName.Text;
                var realName = this.Eval<string>(DAL.JobTry.REALNAME).HtmlEncode();
                if (key.IsNullOrWhiteSpace()) return realName;
                return realName.Highlight(key.HtmlEncode());
            }
        }

        protected string EvalJobName
        {
            get
            {
                var key = this.txtJobName.Text;
                var jobName = this.Eval<string>("JobName").HtmlEncode();
                if (key.IsNullOrWhiteSpace()) return jobName;
                return jobName.Highlight(key.HtmlEncode());
            }
        }

        protected string EvalContact
        {
            get
            {
                var key = this.txtContact.Text;
                var contact = this.Eval<string>(DAL.JobTry.CONTACT).HtmlEncode();
                if (key.IsNullOrWhiteSpace()) return contact;
                return contact.Highlight(key.HtmlEncode());
            }
        }

        protected string EvalAge
        {
            get
            {
                var bday = this.Eval<DateTime?>(DAL.JobTry.BDAY);
                if (bday == null) return "-";
                return (DateTime.Now.Year - bday.Value.Year).ToString();
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.PageBind();
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            this.PageBind();
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            var jobTry = new BLL.JobTry();
            if (e.CommandName == "Del")
            {
                jobTry.Delete(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("删除应聘成功");
            }
        }

        protected void pager_PageIndexChanged(object sender, EventArgs e)
        {
            this.PageBind();
        }
    }
}